(ns lein-nomad.plugin
  (:require [robert.hooke :refer [add-hook]]
            [clojure.java.io :as io]))

(defn nomad-file [{:keys [root target-path]}]
  (io/file target-path ".nomad-file"))

(defn app-config-file [{:keys [root]
                        config-path :nomad/config-path}]
  (if config-path
    (io/file root config-path)
    (binding [*out* *err*]
      (println "WARN: No Nomad config file specified - have you remembered to put a :nomad/config-path key in your project.clj?"))))

(defn write-app-config-file-to-nomad-file [project]
  (when-let [app-config-file (app-config-file project)]
    (spit (nomad-file project) (.getAbsolutePath app-config-file))))

(defn wrap-apply-task [func task-name project args]
  (write-app-config-file-to-nomad-file project)
  (func task-name project args))

(defn hooks []
  (add-hook #'leiningen.core.main/apply-task #'wrap-apply-task ))