(ns flow.forms.if
  (:require                             ))

(defn build-if [test-fn build-then build-else]
  (fn []
    (letfn [(build-branch [test-value]
              (if test-value
                (build-then)
                (build-else)))

            (update-if [old-test-value update-current-branch!]
              (let [new-test-value (boolean (test-fn))
                    
                    new-branch (if (or (nil? old-test-value)
                                       (not= old-test-value new-test-value))
                                 (build-branch new-test-value)
                                 update-current-branch!)
                     
                    [$branch-el update-branch!] (new-branch)]
                
                [$branch-el #(update-if new-test-value update-branch!)]))]
      
      (update-if nil nil))))

     
                                                           
                                                       
                                                    
                                                      

     
                                                              
                                         
                                       
                                         

;;;;;;;;;;;; This file autogenerated from src/flow/forms/if.cljx
