(ns flow.core
        (:require [flow.expand :refer [expand-macros]]
                  [flow.parse :refer [parse-form]]
                  [flow.compile :refer [compile-identity]]
                  [flow.render :refer [render-elem]]
                  [flow.protocols :as fp])
  
                                 
                             
                              
                            
                                
                                 
                                     
                                     )

     
(defn debug-compiled-el [compiled-el]
  (spit "/tmp/compiled.edn"
        {:hard-deps (fp/hard-deps compiled-el)
         :soft-deps (fp/soft-deps compiled-el)
         :declarations (fp/declarations compiled-el)
         :build-form (fp/build-form compiled-el)}))

     
(defmacro el [elem]
  (let [el-sym (gensym "flow-el")]
    
    (-> (expand-macros elem &env)
        (parse-form {:elem? true})
        (doto (->> (spit "/tmp/parsed.edn")))
        (compile-identity {:dynamic-syms #{}
                           :local-syms #{}
                           :path [el-sym]})
        (doto debug-compiled-el)
        (render-elem)
        (doto (->> (spit "/tmp/rendered.edn"))))))

      
                             
          
                                                
                                      
               
        
                                  

      
                        
                        

;;;;;;;;;;;; This file autogenerated from src/flow/core.cljx
