(ns flow.forms.collections
  (:require       [flow.compiler :as fc]))

     
(defmethod fc/compile-value-form :coll [coll opts]
  (->> coll
       (map #(fc/compile-value-form % opts))
       (into (empty coll))))

     
(defmethod fc/compile-value-form :map [m opts]
  (->> (for [[k v] m]
         [(fc/compile-value-form k opts) (fc/compile-value-form v opts)])
       (into {})))

;;;;;;;;;;;; This file autogenerated from src/flow/forms/collections.cljx
