(ns flow.stream-monad
  (:require                                                          
                   [cljs.core.async :as a]
            [flow.stream :refer [ch->stream Stream stream-ch unwrap-nil]])

        
  (:require-macros [cljs.core.async.macros :refer [go go-loop alt!]]))

(defn stream-return [v]
  (ch->stream (doto (a/chan)
                (a/onto-chan [v] false))))

(defn stream-bind* [s f]
  ;; s :: Stream a
  ;; f :: (a -> Stream b)
  ;; returns :: Stream b

  (reify Stream
    (stream-ch [_ cancel-ch buffer-fn]
      (let [out-ch (a/chan (buffer-fn))
            stream-cancel-ch (a/chan)
            stream-value-ch (stream-ch s stream-cancel-ch buffer-fn)]        

        (go-loop [old-stream-value ::initial
                  fn-cancel-ch (a/chan)
                  fn-stream-ch (a/chan)]

          (alt!
            :priority true

            cancel-ch ([_]
                         (a/close! stream-cancel-ch)
                         (a/close! fn-cancel-ch)
                         (a/close! out-ch))

            stream-value-ch ([new-val]
                               (if-not (nil? new-val)

                                 (let [new-val (unwrap-nil new-val)]
                                   (if (= old-stream-value new-val)
                                     (recur old-stream-value fn-cancel-ch fn-stream-ch)
                                                              
                                     (let [new-fn-cancel-ch (a/chan)
                                           new-fn-stream-ch (stream-ch (f new-val) new-fn-cancel-ch buffer-fn)]
                                       (recur new-val new-fn-cancel-ch new-fn-stream-ch))))

                                 (do
                                   (a/close! fn-cancel-ch)
                                   (a/close! out-ch))))

            fn-stream-ch ([new-val]
                            (if-not (nil? new-val)
                              (do
                                (a/>! out-ch new-val)
                                (recur old-stream-value fn-cancel-ch fn-stream-ch))
                             
                              (recur old-stream-value fn-cancel-ch (a/chan))))))
        
        out-ch))))

     
                           
                                                                  
                                                    
                                        
                           
                                  
                                                
                                                      
                                                           
                          
              
                                    
                                                                          
                                                  

                                              

;;;;;;;;;;;; This file autogenerated from src/flow/stream_monad.cljx
