(ns jamesmacaulay.zelkova.window
  "This namespace provides window-related signals."
  (:refer-clojure :exclude [meta])
       
  (:require [jamesmacaulay.zelkova.signal :as z]
            [jamesmacaulay.zelkova.impl.signal :as impl]
            [clojure.core.async :as async])
        
                                                
                                                        
                                                      
                                    
                                                       
        
                                                                )

      
             
                  
                                      
                                                       
         

(defn- get-size
  [opts]
        
                                                       
                              
                                
          
       
  [500 500])

(defn- dimensions-channel
  [graph opts]
        
                                                    
       
  (async/chan))

(def ^:private dimensions-events-fn
  (impl/value-source->events-fn dimensions-channel ::dimensions))

(def ^{:doc "A signal of `[x y]` vectors representing the current dimensions of
the window."}
  dimensions
  (impl/make-signal {:init-fn (fn [_ opts] (get-size opts))
                     :relayed-event-topic ::dimensions
                     :event-sources {::dimensions dimensions-events-fn}}))

(def ^{:doc "A signal of the current width of the window."}
  width
  (z/map first dimensions))

(def ^{:doc "A signal of the current height of the window."}
  height
  (z/map second dimensions))

;;;;;;;;;;;; This file autogenerated from src/cljx/jamesmacaulay/zelkova/window.cljx
