     
                                
                                  
                                                
                                            

      
(ns jamesmacaulay.zelkova.window
  (:refer-clojure :exclude [meta])
  (:require [jamesmacaulay.zelkova.signal :as z]
            [jamesmacaulay.async-tools.core :as tools]
            [goog.events :as events]
            [cljs.core.async :as async :refer [>! <!]])
  (:require-macros [cljs.core.async.macros :refer [go go-loop]]))

      
(defn- listen
  [el type & args]
  (let [out (apply async/chan 1 args)]
    (events/listen el type (fn [e] (async/put! out e)))
    out))

(defn- get-size
  [opts]
        
  (let [node (or (:dom-node opts) (.-body js/document))
        w (.-clientWidth node)
        h (.-clientHeight node)]
    [w h])
       
           )

(defn dimensions-channel
  [graph opts]
        
  (tools/concat (async/to-chan [(get-size opts)])
                (listen js/window "resize" (map #(get-size opts))))
       
              )

(def dimensions
  (z/input [0 0] ::dimensions dimensions-channel))

(def width (z/lift first dimensions))

(def height (z/lift second dimensions))

;;;;;;;;;;;; This file autogenerated from src/cljx/jamesmacaulay/zelkova/window.cljx
