     
(ns jamesmacaulay.zelkova.keyboard
  (:refer-clojure :exclude [meta])
  (:require [jamesmacaulay.zelkova.signal :as z]
            [clojure.core.async :as async]))

      
                                  
                                  
                                                
                                    
                                                       
                                                                 

      
             
                  
                                      
                                                       
         

(defn keydown-channel
  [graph opts]
        
                                
       
  (async/chan))

(defn keyup-channel
  [graph opts]
        
                              
       
  (async/chan))

(defn blur-channel
  [graph opts]
        
                           
       
  (async/chan))

(def down-events
  (z/input 0 ::down-events keydown-channel))

(def up-events
  (z/input 0 ::up-events keyup-channel))

(def blur-events
  (z/input 0 ::blur-events blur-channel))

(def ^:private empty-state {:alt-key false :meta-key false :key-codes #{}})

(defmulti event-action (fn [state event] (.-type event)))

(defmethod event-action "keydown"
  [state event]
  (-> state
      (update-in [:key-codes] conj (.-keyCode event))
      (assoc :alt (.-altKey event)
             :meta (.-metaKey event))))

(defmethod event-action "keyup"
  [state event]
  (-> state
      (update-in [:key-codes] disj (.-keyCode event))
      (assoc :alt (.-altKey event)
             :meta (.-metaKey event))))

(defmethod event-action "blur"
  [state event]
  empty-state)

(def ^:private key-merge
  (->> (z/merge down-events up-events blur-events)
       (z/reducep event-action empty-state)))

(defn- key-signal
  [f]
  (z/drop-repeats (z/lift f key-merge)))

(def keys-down (key-signal :key-codes))

(defn directions
  [up down left right]
  (key-signal (fn [{:keys [key-codes]}]
                {:x (+ (if (key-codes right) 1 0)
                       (if (key-codes left) -1 0))
                 :y (+ (if (key-codes up) 1 0)
                       (if (key-codes down) -1 0))})))

(def arrows (directions 38 40 37 39))

(def wasd (directions 87 83 65 68))

(defn down?
  [code]
  (key-signal (fn [{:keys [key-codes]}]
                (boolean (key-codes code)))))

(def alt (key-signal :alt))

(def meta (key-signal :meta))

(def ctrl (down? 17))

(def shift (down? 16))

(def space (down? 32))

(def enter (down? 13))

(def last-pressed
  (z/lift #(.-keyCode %) down-events))

;;;;;;;;;;;; This file autogenerated from src/cljx/jamesmacaulay/zelkova/keyboard.cljx
