(ns sandbox.tsne
  (:require
    [clojure.core.matrix :as m]
    [think.tsne.core :as tsne]
    [mikera.vectorz.matrix-api]
            ))


(defn random-vector
  []
  (m/array :vectorz (repeatedly 5 rand)))


(defn get-centroid
  [row-seq]
  (let [n-rows (count row-seq)
        row-dim (m/ecount (first row-seq))]
    (m/div (reduce m/add
                   (m/new-array :vectorz [row-dim])
                   row-seq)
           n-rows)))

(defn tmp []
  (let [first-centroid (m/array :vectorz [0 200 0 0 20])
;;          first-centroid (double-array [0 200 0 0 20])
        second-centroid (m/array :vectorz [0 0 -100 0 0])
        vec-set-1 (repeatedly 20 (fn [] (m/add first-centroid (m/mul (random-vector) 5))))
;;         vec-set-1 (mapv float-array vec-set-1)
        vec-set-2 (repeatedly 20 (fn [] (m/add second-centroid (m/mul (random-vector) 5))))
        input-matrix (m/array :vectorz (concat vec-set-1 vec-set-2))]
    (tsne/tsne input-matrix 2 :perplexity 10.0 :tsne-algorithm :parallel-bht)))
