(ns sandbox.gpu
  (:require
    [clojure.core.matrix :refer [matrix array mmul transpose] :as m]
    [uncomplicate.neanderthal.core :refer [sum mv mv! mm alter! transfer! dot trans]]
    [uncomplicate.neanderthal.native :as n]
    [uncomplicate.commons.core :refer [with-release]]
    [uncomplicate.clojurecl.legacy :as legacy]
    [uncomplicate.neanderthal.opencl :refer [clv clge] :as cl]
    [uncomplicate.neanderthal.math :as math]))

(defn make-matrix
  [row col]
  (let [f (doall (repeat row (repeatedly col rand)))]
    (time (matrix f))))

(defn example [mrow b vnum]
  (let [_m (doall (take (* mrow vnum)(repeat mrow (repeatedly vnum rand))))
        m (matrix :vectorz _m)
        v (array :vectorz (repeatedly vnum rand))
        m2 (transpose (matrix :vectorz (repeat b v)))]
    (dotimes [_ 4]
      (time (mmul m m2)))))

(defn mvz
  [m v]
  (mmul m v))

(defn make-matrix-gpu
  [row col]
  (let [f (repeatedly (* row col) rand)]
    (legacy/with-default-1
      (cl/with-default-engine
        (time (with-release [m (clge row col f)]
                (identity m)))))))

(defn example-gpu [mrow b vnum]
  (legacy/with-default-1
    (cl/with-default-engine
      (with-release [m (doall (take (* mrow vnum) (repeatedly (* mrow vnum) rand)))
                     gpu-m  (transfer! m (clge mrow vnum))
                     v (repeatedly vnum rand)
                     gpu-v (transfer! v (clv vnum))
                     m2 (repeat b v)
                     gpu-m2 (trans (clge b vnum (apply concat m2)))];(transfer! m2 (clge (* b vnum))))]
        (dotimes [_ 4]
          (time (mm gpu-m gpu-m2)))))))

(defn mv-gpu
  [m v]
  (mv m v))

(defn example-model []
  (legacy/with-default-1
    (cl/with-default-engine
      (with-release [a (clv (range 5))]
        {:a a}))))
