(ns fogus.thneed.privates)

(defn get-private-field
  [obj field]
  (. (doto (first (filter
                   (fn [x] (.. x getName (equals (name field))))
                   (.. obj
                       getClass
                       getDeclaredFields)))
       (.setAccessible true))
     (get obj)))

(defn invoke-private-method
  [obj meth & args]
  (let [m (first (filter
                  (fn [x] (.. x getName (equals (name meth))))
                  (.. obj getClass getDeclaredMethods)))]
    (.setAccessible m true)
    (.invoke m obj args)))

(comment
  (get-private-field (java.util.Date.) :fastTime)
  (invoke-private-method (java.util.Date.) :getTimeImpl)
)

