/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.art.owlart.protegeimpl.models;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import it.uniroma2.art.owlart.exceptions.ModelAccessException;
import it.uniroma2.art.owlart.model.ARTNode;
import it.uniroma2.art.owlart.model.ARTResource;
import it.uniroma2.art.owlart.model.ARTURIResource;
import it.uniroma2.art.owlart.models.BaseRDFTripleModel;
import it.uniroma2.art.owlart.models.impl.OWLModelImpl;
import it.uniroma2.art.owlart.models.impl.URIResourceIteratorFilteringResourceIterator;
import it.uniroma2.art.owlart.navigation.ARTLiteralIterator;
import it.uniroma2.art.owlart.navigation.ARTNodeIterator;
import it.uniroma2.art.owlart.navigation.ARTResourceIterator;
import it.uniroma2.art.owlart.navigation.ARTURIResourceIterator;
import it.uniroma2.art.owlart.protegeimpl.Protege2ARTResourceFactory;
import it.uniroma2.art.owlart.protegeimpl.ProtegeARTLiteralIteratorImpl;
import it.uniroma2.art.owlart.protegeimpl.ProtegeARTNodeIteratorImpl;
import it.uniroma2.art.owlart.protegeimpl.ProtegeARTPropertyIteratorImpl;
import it.uniroma2.art.owlart.protegeimpl.ProtegeARTResourceIteratorImpl;
import it.uniroma2.art.owlart.protegeimpl.ProtegeARTURIResourceIteratorImpl;
import it.uniroma2.art.owlart.protegeimpl.models.BaseRDFModelProtegeImpl;
import it.uniroma2.art.owlart.vocabulary.OWL;
import it.uniroma2.art.owlart.vocabulary.RDF;
import it.uniroma2.art.owlart.vocabulary.RDFS;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLModelProtegeImpl
extends OWLModelImpl {
    protected static Logger logger = LoggerFactory.getLogger(OWLModelProtegeImpl.class);
    TripleStore tripleStore;
    OWLModel owlModel;

    public OWLModelProtegeImpl(BaseRDFModelProtegeImpl baseRep) {
        super((BaseRDFTripleModel)baseRep);
        this.tripleStore = baseRep.getTripleStore();
        this.owlModel = baseRep.getProtegeOWLModel();
    }

    public Project getProtegeProject() {
        return ((BaseRDFModelProtegeImpl)this.baseRep).getProtegeProject();
    }

    public OWLModel getProtegeOWLModel() {
        return ((BaseRDFModelProtegeImpl)this.baseRep).getProtegeOWLModel();
    }

    public ARTResourceIterator listSubjectsOfPredObjPair(ARTURIResource predicate, ARTNode object, boolean inferred, ARTResource ... graphs) throws ModelAccessException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError("named graphs are not supported in Protege Implementatin of OWL Art API");
        }
        logger.debug("predicate: " + Protege2ARTResourceFactory.aRTURIResource2ProtegeProperty(predicate, this.owlModel));
        logger.debug("value: " + Protege2ARTResourceFactory.aRTNode2ProtegeValue(object, this.owlModel));
        Iterator it = this.tripleStore.listSubjects(Protege2ARTResourceFactory.aRTURIResource2ProtegeProperty(predicate, this.owlModel), (Object)Protege2ARTResourceFactory.aRTNode2ProtegeValue(object, this.owlModel));
        return new ProtegeARTResourceIteratorImpl(it);
    }

    public ARTNodeIterator listValuesOfSubjPredPair(ARTResource subject, ARTURIResource predicate, boolean inferred, ARTResource ... graphs) throws ModelAccessException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError("named graphs are not supported in Protege Implementatin of OWL Art API");
        }
        Iterator it = this.tripleStore.listObjects(Protege2ARTResourceFactory.aRTResource2ProtegeResource(subject, this.owlModel), Protege2ARTResourceFactory.aRTURIResource2ProtegeProperty(predicate, this.owlModel));
        return new ProtegeARTNodeIteratorImpl(it);
    }

    public ARTLiteralIterator listValuesOfSubjDTypePropertyPair(ARTResource subject, ARTURIResource predicate, boolean inferred, ARTResource ... graphs) throws ModelAccessException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError("named graphs are not supported in Protege Implementatin of OWL Art API");
        }
        RDFResource subj = Protege2ARTResourceFactory.aRTResource2ProtegeResource(subject, this.owlModel);
        RDFProperty prop = Protege2ARTResourceFactory.aRTURIResource2ProtegeProperty(predicate, this.owlModel);
        return new ProtegeARTLiteralIteratorImpl(subj.getPropertyValueLiterals(prop).iterator());
    }

    public ARTResourceIterator listValuesOfSubjObjTypePropertyPair(ARTResource subject, ARTURIResource predicate, boolean inferred, ARTResource ... graphs) throws ModelAccessException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError("named graphs are not supported in Protege Implementatin of OWL Art API");
        }
        RDFResource subj = Protege2ARTResourceFactory.aRTResource2ProtegeResource(subject, this.owlModel);
        RDFProperty prop = Protege2ARTResourceFactory.aRTURIResource2ProtegeProperty(predicate, this.owlModel);
        return new ProtegeARTResourceIteratorImpl(subj.getPropertyValues(prop).iterator());
    }

    public ARTURIResourceIterator listNamedClasses(boolean inferred, ARTResource ... graphs) throws ModelAccessException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError("named graphs are not supported in Protege Implementatin of OWL Art API");
        }
        return new ProtegeARTURIResourceIteratorImpl(this.owlModel.listOWLNamedClasses());
    }

    public ARTURIResourceIterator listProperties(ARTResource ... graphs) throws ModelAccessException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError("named graphs are not supported in Protege Implementatin of OWL Art API");
        }
        return new ProtegeARTPropertyIteratorImpl(this.owlModel.listRDFProperties());
    }

    public ARTURIResourceIterator listNamedInstances(ARTResource ... graphs) throws ModelAccessException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError("named graphs are not supported in Protege Implementatin of OWL Art API");
        }
        logger.error("warning this call may vbe not working properly, since not all instances will be instances of OWL InDIVIDUAL");
        return new URIResourceIteratorFilteringResourceIterator(this.listSubjectsOfPredObjPair(RDF.Res.TYPE, (ARTNode)OWL.Res.INDIVIDUAL, false, graphs));
    }

    public ARTLiteralIterator listLabels(ARTResource ontResource, boolean inference, ARTResource ... graphs) throws ModelAccessException {
        return this.listValuesOfSubjDTypePropertyPair(ontResource, RDFS.Res.LABEL, inference, graphs);
    }

    public ARTResourceIterator listInstances(ARTResource type, boolean inferred, ARTResource ... graphs) throws ModelAccessException {
        String typeInternalName = this.owlModel.getResourceNameForURI(((ARTURIResource)type).getURI());
        logger.debug("typeInternalName: " + typeInternalName);
        OWLNamedClass typeCls = this.owlModel.getOWLNamedClass(typeInternalName);
        System.out.println("URI OF CNOUN" + typeCls.getURI());
        logger.debug("typeCls: " + typeCls);
        return new ProtegeARTResourceIteratorImpl(typeCls.getInstances(inferred).iterator());
    }

    public ARTResourceIterator listSubClasses(ARTResource cls, boolean inferred, ARTResource ... graphs) throws ModelAccessException {
        String typeInternalName = this.owlModel.getResourceNameForURI(((ARTURIResource)cls).getURI());
        logger.debug("clsInternalName: " + typeInternalName);
        OWLNamedClass typeCls = this.owlModel.getOWLNamedClass(typeInternalName);
        System.out.println("URI OF CNOUN" + typeCls.getURI());
        logger.debug("typeCls: " + typeCls);
        return new ProtegeARTResourceIteratorImpl(typeCls.getSubclasses(inferred).iterator());
    }

    public ARTResourceIterator listTypes(ARTResource inst, boolean inferred, ARTResource ... graphs) throws ModelAccessException {
        String instInternalName = this.owlModel.getResourceNameForURI(((ARTURIResource)inst).getURI());
        logger.debug("instInternalName: " + instInternalName);
        return this.listValuesOfSubjObjTypePropertyPair(inst, RDF.Res.TYPE, inferred, graphs);
    }
}

