/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.art.owlart.protegeimpl.models;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import it.uniroma2.art.owlart.exceptions.ModelAccessException;
import it.uniroma2.art.owlart.exceptions.ModelUpdateException;
import it.uniroma2.art.owlart.exceptions.UnsupportedQueryLanguageException;
import it.uniroma2.art.owlart.exceptions.UnsupportedRDFFormatException;
import it.uniroma2.art.owlart.io.RDFFormat;
import it.uniroma2.art.owlart.model.ARTBNode;
import it.uniroma2.art.owlart.model.ARTLiteral;
import it.uniroma2.art.owlart.model.ARTNode;
import it.uniroma2.art.owlart.model.ARTResource;
import it.uniroma2.art.owlart.model.ARTStatement;
import it.uniroma2.art.owlart.model.ARTURIResource;
import it.uniroma2.art.owlart.model.NodeFilters;
import it.uniroma2.art.owlart.models.BaseRDFTripleModel;
import it.uniroma2.art.owlart.navigation.ARTNamespaceIterator;
import it.uniroma2.art.owlart.navigation.ARTResourceIterator;
import it.uniroma2.art.owlart.navigation.ARTStatementIterator;
import it.uniroma2.art.owlart.protegeimpl.Protege2ARTResourceFactory;
import it.uniroma2.art.owlart.protegeimpl.ProtegeARTNamespaceIteratorImpl;
import it.uniroma2.art.owlart.protegeimpl.ProtegeARTStatementIteratorImpl;
import it.uniroma2.art.owlart.protegeimpl.TripleType;
import it.uniroma2.art.owlart.protegeimpl.io.RDFFormatConverter;
import it.uniroma2.art.owlart.protegeimpl.model.ARTURIResourceEmptyImpl;
import it.uniroma2.art.owlart.query.BooleanQuery;
import it.uniroma2.art.owlart.query.GraphQuery;
import it.uniroma2.art.owlart.query.MalformedQueryException;
import it.uniroma2.art.owlart.query.Query;
import it.uniroma2.art.owlart.query.QueryLanguage;
import it.uniroma2.art.owlart.query.TupleQuery;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseRDFModelProtegeImpl
implements BaseRDFTripleModel {
    protected static Logger logger = LoggerFactory.getLogger(BaseRDFModelProtegeImpl.class);
    public static final String graphUnsupportedMsg = "named graphs are not supported in Protege Implementatin of OWL Art API";
    protected Project project;
    protected OWLModel owlModel;
    protected TripleStore tripleStore;
    protected TripleStoreModel tripleStoreModel;
    protected String baseURI;
    protected String defaultNamespace;
    public final String SPARQLnotSupported = "SPARQL nor any other query language is supported at the moment in Protege Impl of OWLArt API";

    public BaseRDFModelProtegeImpl(Project project) {
        this.project = project;
        this.owlModel = (OWLModel)project.getKnowledgeBase();
        this.tripleStoreModel = this.owlModel.getTripleStoreModel();
        this.tripleStore = this.tripleStoreModel.getTopTripleStore();
    }

    public Project getProtegeProject() {
        return this.project;
    }

    public OWLModel getProtegeOWLModel() {
        return this.owlModel;
    }

    TripleStore getTripleStore() {
        return this.tripleStore;
    }

    TripleStoreModel getTripleStoreModel() {
        return this.tripleStoreModel;
    }

    public void addRDF(File inputFile, String baseURI, RDFFormat rdfFormat, ARTResource ... graphs) throws FileNotFoundException, IOException, ModelAccessException, ModelUpdateException, UnsupportedRDFFormatException {
        throw new IllegalAccessError("import still not implemented in Protege implementation of OWL ART API");
    }

    public void addRDF(URL url, String baseURI, RDFFormat rdfFormat, ARTResource ... graphs) throws FileNotFoundException, IOException, ModelAccessException, ModelUpdateException, UnsupportedRDFFormatException {
        throw new IllegalAccessError("import still not implemented in Protege implementation of OWL ART API");
    }

    public void addStatement(ARTStatement stat, ARTResource ... graphs) throws ModelUpdateException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError(graphUnsupportedMsg);
        }
        this.tripleStore.add(Protege2ARTResourceFactory.aRTStatement2ProtegeTriple(stat));
    }

    public void addTriple(ARTResource subject, ARTURIResource predicate, ARTNode object, ARTResource ... graphs) throws ModelUpdateException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError(graphUnsupportedMsg);
        }
        this.tripleStore.add(Protege2ARTResourceFactory.aRTResource2ProtegeResource(subject, this.owlModel), Protege2ARTResourceFactory.aRTURIResource2ProtegeProperty(predicate, this.owlModel), (Object)Protege2ARTResourceFactory.aRTNode2ProtegeValue(object, this.owlModel));
    }

    public ARTURIResource createURIResource(String uri) {
        return new ARTURIResourceEmptyImpl(uri, this.owlModel);
    }

    public void close() throws ModelUpdateException {
        this.project.dispose();
    }

    public ARTBNode createBNode() {
        throw new IllegalStateException("still to be implemented");
    }

    public ARTBNode createBNode(String ID) {
        throw new IllegalStateException("still to be implemented");
    }

    public ARTLiteral createLiteral(String literalString) {
        return Protege2ARTResourceFactory.protegeLiteral2ARTLiteral(this.owlModel.createRDFSLiteral(literalString, (String)null));
    }

    public ARTLiteral createLiteral(String literalString, String language) {
        return Protege2ARTResourceFactory.protegeLiteral2ARTLiteral(this.owlModel.createRDFSLiteral(literalString, language));
    }

    public void deleteStatement(ARTStatement statement, ARTResource ... graphs) throws ModelUpdateException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError(graphUnsupportedMsg);
        }
        this.tripleStore.remove(Protege2ARTResourceFactory.aRTStatement2ProtegeTriple(statement));
    }

    public void deleteTriple(ARTResource subject, ARTURIResource property, ARTNode object, ARTResource ... graphs) throws ModelUpdateException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError(graphUnsupportedMsg);
        }
        this.tripleStore.remove(Protege2ARTResourceFactory.aRTResource2ProtegeResource(subject, this.owlModel), Protege2ARTResourceFactory.aRTURIResource2ProtegeProperty(property, this.owlModel), (Object)Protege2ARTResourceFactory.aRTNode2ProtegeValue(object, this.owlModel));
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getDefaultNamespace() {
        return this.tripleStore.getDefaultNamespace();
    }

    public boolean hasStatement(ARTStatement stat, boolean inferred, ARTResource ... graphs) throws ModelAccessException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError(graphUnsupportedMsg);
        }
        return this.tripleStore.contains(Protege2ARTResourceFactory.aRTStatement2ProtegeTriple(stat));
    }

    public boolean hasTriple(ARTResource subj, ARTURIResource pred, ARTNode obj, boolean inferred, ARTResource ... graphs) throws ModelAccessException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError(graphUnsupportedMsg);
        }
        return this.tripleStore.contains(Protege2ARTResourceFactory.aRTResource2ProtegeResource(subj, this.owlModel), Protege2ARTResourceFactory.aRTURIResource2ProtegeProperty(pred, this.owlModel), (Object)Protege2ARTResourceFactory.aRTNode2ProtegeValue(obj, this.owlModel));
    }

    public ARTResourceIterator listNamedGraphs() throws ModelAccessException {
        throw new IllegalAccessError(graphUnsupportedMsg);
    }

    public ARTNamespaceIterator listNamespaces() throws ModelAccessException {
        ArrayList<String> namespaces = new ArrayList<String>();
        Collection prefixes = this.tripleStore.getPrefixes();
        for (String prefix : prefixes) {
            namespaces.add(this.tripleStore.getNamespaceForPrefix(prefix));
        }
        return new ProtegeARTNamespaceIteratorImpl(namespaces.iterator(), this.tripleStore);
    }

    public ARTStatementIterator listStatements(ARTResource subj, ARTURIResource pred, ARTNode obj, boolean inferred, ARTResource ... graphs) throws ModelAccessException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError(graphUnsupportedMsg);
        }
        Iterator tripleIterator = null;
        RDFResource subject = null;
        RDFProperty predicate = null;
        RDFObject object = null;
        if (subj != NodeFilters.ANY) {
            subject = Protege2ARTResourceFactory.aRTResource2ProtegeResource(subj, this.owlModel);
        }
        if (pred != NodeFilters.ANY) {
            predicate = Protege2ARTResourceFactory.aRTURIResource2ProtegeProperty(pred, this.owlModel);
        }
        if (obj != NodeFilters.ANY) {
            object = Protege2ARTResourceFactory.aRTNode2ProtegeValue(obj, this.owlModel);
        }
        TripleType type = this.getTripleType(subj, pred, obj);
        switch (type) {
            case AAA: {
                logger.debug("case AAA");
                tripleIterator = this.tripleStore.listTriples();
                break;
            }
            case AAO: {
                logger.debug("case AAO");
                tripleIterator = this.tripleStore.listTriplesWithObject(object);
                break;
            }
            case SAA: {
                logger.debug("case SAA; subject = " + subject);
                tripleIterator = this.tripleStore.listTriplesWithSubject(subject);
                break;
            }
            case APA: {
                logger.debug("type: " + (Object)((Object)TripleType.APA));
                logger.error("in Protege implementation we're unable to list triples through specification of the sole predicate; sorry no alternative solution");
                throw new IllegalAccessError("in Protege implementation we're unable to list triples through specification of the sole predicate; sorry no alternative solution");
            }
            case APO: {
                logger.debug("type: " + (Object)((Object)TripleType.APO) + "for predicate: " + predicate + " and object: " + object);
                logger.error("in Protege implementation we're unable to list triples through specification of predicateobject pairs; hint: use listSubjectsOfPredObjPair... instead");
                throw new IllegalAccessError("in Protege implementation we're unable to list triples through specification of predicateobject pairs; hint: use listSubjectsOfPredObjPair... instead");
            }
            case SAO: {
                logger.debug("type: " + (Object)((Object)TripleType.SAO));
                logger.error("in Protege implementation we're unable to list triples through specification of subjectobject pairs; hint: use RDF.listPredicates... instead");
                throw new IllegalAccessError("in Protege implementation we're unable to list triples through specification of subjectobject pairs; hint: use RDF.listPredicates... instead");
            }
            case SPA: {
                logger.debug("type: " + (Object)((Object)TripleType.SPA));
                logger.error("in Protege implementation we're unable to list triples through specification of subjectpredicate pairs; hint: use RDF.listValuesOfSubjPredPair... instead");
                throw new IllegalAccessError("in Protege implementation we're unable to list triples through specification of subjectpredicate pairs; hint: use RDF.listValuesOfSubjPredPair... instead");
            }
            case SPO: {
                ArrayList<Triple> tripleList = new ArrayList<Triple>();
                if (this.tripleStore.contains(subject, predicate, (Object)object)) {
                    tripleList.add(this.owlModel.createTriple(subject, predicate, (Object)object));
                }
                tripleIterator = tripleList.iterator();
            }
        }
        return new ProtegeARTStatementIteratorImpl(tripleIterator);
    }

    public void setBaseURI(String uri) throws ModelUpdateException {
        this.baseURI = uri;
    }

    public void setDefaultNamespace(String namespace) throws ModelUpdateException {
        this.tripleStore.setDefaultNamespace(namespace);
    }

    public void writeRDF(File outputFile, RDFFormat rdfFormat, ARTResource ... graphs) throws IOException, ModelAccessException, UnsupportedRDFFormatException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError(graphUnsupportedMsg);
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        this.owlModel.getJenaModel().write((OutputStream)fos, RDFFormatConverter.convert(rdfFormat), this.baseURI);
    }

    public void writeRDF(OutputStream os, RDFFormat rdfFormat, ARTResource ... graphs) throws IOException, ModelAccessException, UnsupportedRDFFormatException {
        if (graphs != null && graphs.length != 0) {
            throw new IllegalAccessError(graphUnsupportedMsg);
        }
        this.owlModel.getJenaModel().write(os, RDFFormatConverter.convert(rdfFormat), this.baseURI);
    }

    public String expandQName(String qname) throws ModelAccessException {
        return this.owlModel.getURIForResourceName(qname);
    }

    public String getNSForPrefix(String prefix) throws ModelAccessException {
        return this.tripleStore.getNamespaceForPrefix(prefix);
    }

    public Map<String, String> getNamespacePrefixMapping() throws ModelAccessException {
        HashMap<String, String> res = new HashMap<String, String>();
        Collection prefixes = this.tripleStore.getPrefixes();
        for (String prefix : prefixes) {
            res.put(prefix, this.tripleStore.getNamespaceForPrefix(prefix));
        }
        return res;
    }

    public String getPrefixForNS(String namespace) throws ModelAccessException {
        return this.tripleStore.getPrefix(namespace);
    }

    public String getQName(String uri) throws ModelAccessException {
        return this.owlModel.getResourceNameForURI(uri);
    }

    public boolean hasExplicitPrefixMapping(String namespace) throws ModelAccessException {
        return false;
    }

    public void removeNsPrefixMapping(String namespace) throws ModelUpdateException {
        this.tripleStore.removePrefix(this.tripleStore.getPrefix(namespace));
    }

    public void setNsPrefix(String namespace, String prefix) throws ModelUpdateException {
        this.tripleStore.setPrefix(namespace, prefix);
    }

    public TripleType getTripleType(ARTResource subj, ARTURIResource pred, ARTNode obj) {
        if (subj == NodeFilters.ANY) {
            if (pred == NodeFilters.ANY) {
                if (obj == NodeFilters.ANY) {
                    return TripleType.AAA;
                }
                return TripleType.AAO;
            }
            if (obj == NodeFilters.ANY) {
                return TripleType.APA;
            }
            return TripleType.APO;
        }
        if (pred == NodeFilters.ANY) {
            if (obj == NodeFilters.ANY) {
                return TripleType.SAA;
            }
            return TripleType.SAO;
        }
        if (obj == NodeFilters.ANY) {
            return TripleType.SPA;
        }
        return TripleType.SPO;
    }

    public BooleanQuery createBooleanQuery(QueryLanguage ql, String query, String baseURI) throws UnsupportedQueryLanguageException, ModelAccessException, MalformedQueryException {
        throw new UnsupportedQueryLanguageException("SPARQL nor any other query language is supported at the moment in Protege Impl of OWLArt API");
    }

    public GraphQuery createGraphQuery(QueryLanguage ql, String query, String baseURI) throws UnsupportedQueryLanguageException, ModelAccessException, MalformedQueryException {
        throw new UnsupportedQueryLanguageException("SPARQL nor any other query language is supported at the moment in Protege Impl of OWLArt API");
    }

    public Query createQuery(QueryLanguage ql, String query, String baseURI) throws UnsupportedQueryLanguageException, ModelAccessException, MalformedQueryException {
        throw new UnsupportedQueryLanguageException("SPARQL nor any other query language is supported at the moment in Protege Impl of OWLArt API");
    }

    public TupleQuery createTupleQuery(QueryLanguage ql, String query, String baseURI) throws UnsupportedQueryLanguageException, ModelAccessException, MalformedQueryException {
        throw new UnsupportedQueryLanguageException("SPARQL nor any other query language is supported at the moment in Protege Impl of OWLArt API");
    }

    public void clearRDF(ARTResource ... graphs) throws ModelUpdateException {
        throw new IllegalAccessError("RDF clearance is not supported by this repository ");
    }
}

