/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.art.owlart.protegeimpl.factory;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import it.uniroma2.art.owlart.exceptions.ModelCreationException;
import it.uniroma2.art.owlart.exceptions.ModelUpdateException;
import it.uniroma2.art.owlart.exceptions.VocabularyInitializationException;
import it.uniroma2.art.owlart.model.ARTResource;
import it.uniroma2.art.owlart.models.BaseRDFTripleModel;
import it.uniroma2.art.owlart.models.ModelFactory;
import it.uniroma2.art.owlart.models.OWLModel;
import it.uniroma2.art.owlart.models.RDFModel;
import it.uniroma2.art.owlart.models.RDFSModel;
import it.uniroma2.art.owlart.models.impl.RDFModelImpl;
import it.uniroma2.art.owlart.models.impl.RDFSModelImpl;
import it.uniroma2.art.owlart.protegeimpl.models.BaseRDFModelProtegeImpl;
import it.uniroma2.art.owlart.protegeimpl.models.OWLModelProtegeImpl;
import it.uniroma2.art.owlart.vocabulary.OWL;
import it.uniroma2.art.owlart.vocabulary.RDF;
import it.uniroma2.art.owlart.vocabulary.RDFS;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ARTModelFactoryProtegeImpl
implements ModelFactory {
    protected static Logger logger = LoggerFactory.getLogger(ARTModelFactoryProtegeImpl.class);

    public BaseRDFModelProtegeImpl loadRDFBaseModel(String baseuri, String repositoryDirectory, boolean persist) throws ModelCreationException {
        return this.loadRDFBaseModel(baseuri, repositoryDirectory, "test.owl");
    }

    public BaseRDFModelProtegeImpl loadRDFBaseModel(String baseuri, String repositoryDirectory, String file) throws ModelCreationException {
        logger.info("creating File based Protege implementation of RDFBaseModel at location " + repositoryDirectory + "/" + file);
        JenaKnowledgeBaseFactory factory = new JenaKnowledgeBaseFactory();
        ArrayList errors = new ArrayList();
        Project project = Project.createNewProject((KnowledgeBaseFactory)factory, errors);
        String workingDir = System.getProperty("user.dir").replace("\\", "/");
        JenaKnowledgeBaseFactory.setOWLFileName((PropertyList)project.getSources(), (String)("file:/" + workingDir + "/" + repositoryDirectory + "/" + file));
        project.createDomainKnowledgeBase((KnowledgeBaseFactory)factory, errors, true);
        BaseRDFModelProtegeImpl rep = new BaseRDFModelProtegeImpl(project);
        logger.info("loaded Protege ART RDFBaseModel model: " + rep);
        return rep;
    }

    public BaseRDFModelProtegeImpl loadRDFBaseModel(String dbDriver, String dbUrl, String dbTableName, String dbUserName, String dbPassword) throws ModelCreationException {
        logger.info("creating Database Protege OWLModel: " + dbUrl);
        OWLDatabaseKnowledgeBaseFactory factory = new OWLDatabaseKnowledgeBaseFactory();
        ArrayList errors = new ArrayList();
        Project project = Project.createNewProject((KnowledgeBaseFactory)factory, errors);
        OWLDatabaseKnowledgeBaseFactory.setSources((PropertyList)project.getSources(), (String)dbDriver, (String)dbUrl, (String)dbTableName, (String)dbUserName, (String)dbPassword);
        project.createDomainKnowledgeBase((KnowledgeBaseFactory)factory, errors, true);
        BaseRDFModelProtegeImpl rep = new BaseRDFModelProtegeImpl(project);
        return rep;
    }

    public void clearModel(BaseRDFTripleModel rep) throws ModelUpdateException {
        rep.clearRDF(new ARTResource[0]);
    }

    public RDFModel loadRDFModel(String baseuri, String repositoryDirectory, boolean persist) throws ModelCreationException {
        BaseRDFModelProtegeImpl baseModel = this.loadRDFBaseModel(baseuri, repositoryDirectory, persist);
        RDFModelImpl model = new RDFModelImpl((BaseRDFTripleModel)baseModel);
        return model;
    }

    public RDFSModel loadRDFSModel(String baseuri, String repositoryDirectory, boolean persist) throws ModelCreationException {
        BaseRDFModelProtegeImpl baseModel = this.loadRDFBaseModel(baseuri, repositoryDirectory, persist);
        RDFSModelImpl model = new RDFSModelImpl((BaseRDFTripleModel)baseModel);
        return model;
    }

    public OWLModel loadOWLModel(String baseuri, String repositoryDirectory, boolean persist) throws ModelCreationException {
        BaseRDFModelProtegeImpl baseModel = this.loadRDFBaseModel(baseuri, repositoryDirectory, persist);
        OWLModelProtegeImpl model = new OWLModelProtegeImpl(baseModel);
        return model;
    }

    public OWLModel loadOWLModel(String baseuri, String repositoryDirectory, String file) throws ModelCreationException, ModelUpdateException {
        BaseRDFModelProtegeImpl baseModel = this.loadRDFBaseModel(baseuri, repositoryDirectory, file);
        OWLModelProtegeImpl model = new OWLModelProtegeImpl(baseModel);
        try {
            RDF.Res.initialize((RDFModel)model);
            RDFS.Res.initialize((RDFModel)model);
            OWL.Res.initialize((RDFModel)model);
            model.setBaseURI(baseuri);
            return model;
        }
        catch (VocabularyInitializationException e) {
            throw new ModelCreationException((Exception)((Object)e));
        }
    }

    public OWLModel loadOWLModel(String dbDriver, String dbUrl, String dbTableName, String dbUserName, String dbPassword) throws ModelCreationException {
        BaseRDFModelProtegeImpl baseModel = this.loadRDFBaseModel(dbDriver, dbUrl, dbTableName, dbUserName, dbPassword);
        OWLModelProtegeImpl model = new OWLModelProtegeImpl(baseModel);
        try {
            RDF.Res.initialize((RDFModel)model);
            RDFS.Res.initialize((RDFModel)model);
            OWL.Res.initialize((RDFModel)model);
            return model;
        }
        catch (VocabularyInitializationException e) {
            throw new ModelCreationException((Exception)((Object)e));
        }
    }

    public void closeModel(BaseRDFTripleModel rep) throws ModelUpdateException {
        rep.close();
    }
}

