/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.filters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.filters.unsupervised.attribute.AddUserFields;
import weka.gui.JListHelper;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.EnvironmentField;
import weka.gui.beans.GOECustomizer;

public class AddUserFieldsCustomizer
extends JPanel
implements EnvironmentHandler,
GOECustomizer {
    private static final long serialVersionUID = -3823417827142174931L;
    protected BeanCustomizer.ModifyListener m_modifyL = null;
    protected Environment m_env = Environment.getSystemWide();
    protected AddUserFields m_filter = null;
    protected EnvironmentField m_nameField;
    protected JComboBox m_typeField;
    protected EnvironmentField m_dateFormatField;
    protected EnvironmentField m_valueField;
    protected JList m_list = new JList();
    protected DefaultListModel m_listModel;
    protected JButton m_newBut = new JButton("New");
    protected JButton m_deleteBut = new JButton("Delete");
    protected JButton m_upBut = new JButton("Move up");
    protected JButton m_downBut = new JButton("Move down");
    protected boolean m_dontShowButs = false;

    public AddUserFieldsCustomizer() {
        this.setLayout(new BorderLayout());
    }

    private void setup() {
        JPanel fieldHolder = new JPanel();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout());
        namePanel.setBorder(BorderFactory.createTitledBorder("Attribute name"));
        this.m_nameField = new EnvironmentField(this.m_env);
        namePanel.add((Component)this.m_nameField, "Center");
        namePanel.setToolTipText("Name of the new attribute");
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BorderLayout());
        typePanel.setBorder(BorderFactory.createTitledBorder("Attribute type"));
        this.m_typeField = new JComboBox();
        this.m_typeField.addItem("numeric");
        this.m_typeField.addItem("nominal");
        this.m_typeField.addItem("string");
        this.m_typeField.addItem("date");
        typePanel.add((Component)this.m_typeField, "Center");
        this.m_typeField.setToolTipText("Attribute type");
        typePanel.setToolTipText("Attribute type");
        JPanel formatPanel = new JPanel();
        formatPanel.setLayout(new BorderLayout());
        formatPanel.setBorder(BorderFactory.createTitledBorder("Date format"));
        this.m_dateFormatField = new EnvironmentField(this.m_env);
        formatPanel.add((Component)this.m_dateFormatField, "Center");
        formatPanel.setToolTipText("Date format (date attributes only)");
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout(new BorderLayout());
        valuePanel.setBorder(BorderFactory.createTitledBorder("Attribute value"));
        this.m_valueField = new EnvironmentField(this.m_env);
        valuePanel.add((Component)this.m_valueField, "Center");
        valuePanel.setToolTipText("<html>Constant value (number, string or date)<br>for field. Special value \"now\" can be<br>used for date attributes for the current<br>time stamp</html>");
        fieldHolder.add(namePanel);
        fieldHolder.add(typePanel);
        fieldHolder.add(formatPanel);
        fieldHolder.add(valuePanel);
        this.add((Component)fieldHolder, "North");
        this.m_list.setVisibleRowCount(5);
        this.m_deleteBut.setEnabled(false);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 0));
        butHolder.add(this.m_newBut);
        butHolder.add(this.m_deleteBut);
        butHolder.add(this.m_upBut);
        butHolder.add(this.m_downBut);
        this.m_upBut.setEnabled(false);
        this.m_downBut.setEnabled(false);
        listPanel.add((Component)butHolder, "North");
        JScrollPane js = new JScrollPane(this.m_list);
        js.setBorder(BorderFactory.createTitledBorder("Match-list list (rows applied in order)"));
        listPanel.add((Component)js, "Center");
        this.add((Component)listPanel, "Center");
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object entry;
                    if (!AddUserFieldsCustomizer.this.m_deleteBut.isEnabled()) {
                        AddUserFieldsCustomizer.this.m_deleteBut.setEnabled(true);
                    }
                    if ((entry = AddUserFieldsCustomizer.this.m_list.getSelectedValue()) != null) {
                        AddUserFields.AttributeSpec m = (AddUserFields.AttributeSpec)entry;
                        AddUserFieldsCustomizer.this.m_nameField.setText(m.getName());
                        AddUserFieldsCustomizer.this.m_valueField.setText(m.getValue());
                        String type2 = m.getType();
                        String format = "";
                        if (type2.startsWith("date") && type2.indexOf(":") > 0) {
                            format = type2.substring(type2.indexOf(":") + 1, type2.length());
                            type2 = type2.substring(0, type2.indexOf(":"));
                        }
                        AddUserFieldsCustomizer.this.m_typeField.setSelectedItem(type2.trim());
                        AddUserFieldsCustomizer.this.m_dateFormatField.setText(format);
                    }
                }
            }
        });
        this.m_nameField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object a = AddUserFieldsCustomizer.this.m_list.getSelectedValue();
                if (a != null) {
                    ((AddUserFields.AttributeSpec)a).setName(AddUserFieldsCustomizer.this.m_nameField.getText());
                    AddUserFieldsCustomizer.this.m_list.repaint();
                }
            }
        });
        this.m_typeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object a = AddUserFieldsCustomizer.this.m_list.getSelectedValue();
                if (a != null) {
                    String format;
                    String type2 = AddUserFieldsCustomizer.this.m_typeField.getSelectedItem().toString();
                    if (type2.startsWith("date") && (format = AddUserFieldsCustomizer.this.m_dateFormatField.getText()) != null && format.length() > 0) {
                        type2 = type2 + ":" + format;
                    }
                    ((AddUserFields.AttributeSpec)a).setType(type2);
                    AddUserFieldsCustomizer.this.m_list.repaint();
                }
            }
        });
        this.m_valueField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object a = AddUserFieldsCustomizer.this.m_list.getSelectedValue();
                if (a != null) {
                    ((AddUserFields.AttributeSpec)a).setValue(AddUserFieldsCustomizer.this.m_valueField.getText());
                    AddUserFieldsCustomizer.this.m_list.repaint();
                }
            }
        });
        this.m_newBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserFields.AttributeSpec a = new AddUserFields.AttributeSpec();
                String name = AddUserFieldsCustomizer.this.m_nameField.getText() != null && AddUserFieldsCustomizer.this.m_nameField.getText().length() > 0 ? AddUserFieldsCustomizer.this.m_nameField.getText() : "newAtt";
                a.setName(name);
                String type2 = AddUserFieldsCustomizer.this.m_typeField.getSelectedItem().toString();
                if (type2.startsWith("date") && AddUserFieldsCustomizer.this.m_dateFormatField.getText() != null && AddUserFieldsCustomizer.this.m_dateFormatField.getText().length() > 0) {
                    type2 = type2 + ":" + AddUserFieldsCustomizer.this.m_dateFormatField.getText();
                }
                a.setType(type2);
                String value = AddUserFieldsCustomizer.this.m_valueField.getText() != null ? AddUserFieldsCustomizer.this.m_valueField.getText() : "";
                a.setValue(value);
                AddUserFieldsCustomizer.this.m_listModel.addElement(a);
                if (AddUserFieldsCustomizer.this.m_listModel.size() > 1) {
                    AddUserFieldsCustomizer.this.m_upBut.setEnabled(true);
                    AddUserFieldsCustomizer.this.m_downBut.setEnabled(true);
                }
                if (AddUserFieldsCustomizer.this.m_listModel.size() > 0) {
                    AddUserFieldsCustomizer.this.m_nameField.setEnabled(true);
                    AddUserFieldsCustomizer.this.m_typeField.setEnabled(true);
                    AddUserFieldsCustomizer.this.m_dateFormatField.setEnabled(true);
                    AddUserFieldsCustomizer.this.m_valueField.setEnabled(true);
                }
                AddUserFieldsCustomizer.this.m_list.setSelectedIndex(AddUserFieldsCustomizer.this.m_listModel.size() - 1);
            }
        });
        this.m_deleteBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = AddUserFieldsCustomizer.this.m_list.getSelectedIndex();
                if (selected >= 0) {
                    AddUserFieldsCustomizer.this.m_listModel.removeElementAt(selected);
                    if (AddUserFieldsCustomizer.this.m_listModel.size() <= 1) {
                        AddUserFieldsCustomizer.this.m_upBut.setEnabled(false);
                        AddUserFieldsCustomizer.this.m_downBut.setEnabled(false);
                    }
                    if (AddUserFieldsCustomizer.this.m_listModel.size() == 0) {
                        AddUserFieldsCustomizer.this.m_nameField.setEnabled(false);
                        AddUserFieldsCustomizer.this.m_typeField.setEnabled(false);
                        AddUserFieldsCustomizer.this.m_dateFormatField.setEnabled(false);
                        AddUserFieldsCustomizer.this.m_valueField.setEnabled(false);
                    }
                }
            }
        });
        this.m_upBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveUp(AddUserFieldsCustomizer.this.m_list);
            }
        });
        this.m_downBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveDown(AddUserFieldsCustomizer.this.m_list);
            }
        });
        if (this.m_dontShowButs) {
            return;
        }
        this.addButtons();
    }

    private void addButtons() {
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        this.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserFieldsCustomizer.this.closingOK();
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserFieldsCustomizer.this.closingCancel();
            }
        });
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyL = l;
    }

    protected void initialize() {
        List<AddUserFields.AttributeSpec> specs = this.m_filter.getAttributeSpecs();
        this.m_listModel = new DefaultListModel();
        this.m_list.setModel(this.m_listModel);
        if (specs.size() > 0) {
            this.m_upBut.setEnabled(true);
            this.m_downBut.setEnabled(true);
            for (AddUserFields.AttributeSpec s : specs) {
                AddUserFields.AttributeSpec specCopy = new AddUserFields.AttributeSpec(s.toStringInternal());
                this.m_listModel.addElement(specCopy);
            }
            this.m_list.repaint();
        } else {
            this.m_nameField.setEnabled(false);
            this.m_typeField.setEnabled(false);
            this.m_dateFormatField.setEnabled(false);
            this.m_valueField.setEnabled(false);
        }
    }

    @Override
    public void setObject(Object o) {
        if (o instanceof AddUserFields) {
            this.m_filter = (AddUserFields)o;
            this.setup();
            this.initialize();
        }
    }

    @Override
    public void dontShowOKCancelButtons() {
        this.m_dontShowButs = true;
    }

    @Override
    public void closingOK() {
        ArrayList<AddUserFields.AttributeSpec> specs = new ArrayList<AddUserFields.AttributeSpec>();
        for (int i = 0; i < this.m_listModel.size(); ++i) {
            AddUserFields.AttributeSpec a = (AddUserFields.AttributeSpec)this.m_listModel.elementAt(i);
            specs.add(a);
        }
        if (this.m_modifyL != null) {
            this.m_modifyL.setModifiedStatus(this, true);
        }
        this.m_filter.setAttributeSpecs(specs);
    }

    @Override
    public void closingCancel() {
    }
}

