/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import weka.core.Attribute;
import weka.core.Environment;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.AttributeVisualizationPanel;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataVisualizer;
import weka.gui.beans.ImageEvent;
import weka.gui.beans.KnowledgeFlowApp;

public class AttributeSummarizer
extends DataVisualizer
implements KnowledgeFlowApp.KFPerspective {
    private static final long serialVersionUID = -294354961169372758L;
    protected int m_gridWidth = 4;
    protected int m_maxPlots = 100;
    protected int m_coloringIndex = -1;
    protected boolean m_showClassCombo = false;
    protected boolean m_runningAsPerspective = false;
    protected boolean m_activePerspective = false;
    protected transient List<AttributeVisualizationPanel> m_plots;

    public AttributeSummarizer() {
        this.useDefaultVisual();
        this.m_visual.setText("AttributeSummarizer");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!ge.isHeadless()) {
            this.appearanceFinal();
        }
    }

    @Override
    public String globalInfo() {
        return "Plot summary bar charts for incoming data/training/test sets.";
    }

    public void setColoringIndex(int ci) {
        this.m_coloringIndex = ci;
    }

    public int getColoringIndex() {
        return this.m_coloringIndex;
    }

    public void setGridWidth(int gw) {
        if (gw > 0) {
            this.m_bcSupport.firePropertyChange("gridWidth", new Integer(this.m_gridWidth), new Integer(gw));
            this.m_gridWidth = gw;
        }
    }

    public int getGridWidth() {
        return this.m_gridWidth;
    }

    public void setMaxPlots(int mp) {
        if (mp > 0) {
            this.m_bcSupport.firePropertyChange("maxPlots", new Integer(this.m_maxPlots), new Integer(mp));
            this.m_maxPlots = mp;
        }
    }

    public int getMaxPlots() {
        return this.m_maxPlots;
    }

    public void setDesign(boolean design) {
        this.m_design = true;
        this.appearanceDesign();
    }

    @Override
    protected void appearanceDesign() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    @Override
    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
    }

    @Override
    protected void setUpFinal() {
        this.removeAll();
        if (this.m_visualizeDataSet == null) {
            return;
        }
        if (!this.m_runningAsPerspective || this.m_activePerspective) {
            JScrollPane hp = this.makePanel();
            this.add((Component)hp, "Center");
            if (this.m_showClassCombo) {
                Vector<String> atts = new Vector<String>();
                for (int i = 0; i < this.m_visualizeDataSet.numAttributes(); ++i) {
                    atts.add("(" + Attribute.typeToStringShort(this.m_visualizeDataSet.attribute(i)) + ") " + this.m_visualizeDataSet.attribute(i).name());
                }
                final JComboBox classCombo = new JComboBox();
                classCombo.setModel(new DefaultComboBoxModel(atts));
                if (atts.size() > 0) {
                    if (this.m_visualizeDataSet.classIndex() < 0) {
                        classCombo.setSelectedIndex(atts.size() - 1);
                    } else {
                        classCombo.setSelectedIndex(this.m_visualizeDataSet.classIndex());
                    }
                    classCombo.setEnabled(true);
                    for (int i = 0; i < this.m_plots.size(); ++i) {
                        this.m_plots.get(i).setColoringIndex(classCombo.getSelectedIndex());
                    }
                }
                JPanel comboHolder = new JPanel();
                comboHolder.setLayout(new BorderLayout());
                JPanel tempHolder = new JPanel();
                tempHolder.setLayout(new BorderLayout());
                tempHolder.add((Component)new JLabel("Class: "), "West");
                tempHolder.add(classCombo, "East");
                comboHolder.add((Component)tempHolder, "West");
                this.add((Component)comboHolder, "North");
                classCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selected = classCombo.getSelectedIndex();
                        if (selected >= 0) {
                            for (int i = 0; i < AttributeSummarizer.this.m_plots.size(); ++i) {
                                AttributeSummarizer.this.m_plots.get(i).setColoringIndex(selected);
                            }
                        }
                    }
                });
            }
        }
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/AttributeSummarizer.gif", "weka/gui/beans/icons/AttributeSummarizer_animated.gif");
    }

    @Override
    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_visualizeDataSet != null) {
            newVector.addElement("Show summaries");
        }
        return newVector.elements();
    }

    private JScrollPane makePanel() {
        String fontFamily = this.getFont().getFamily();
        Font newFont = new Font(fontFamily, 0, 10);
        JPanel hp = new JPanel();
        hp.setFont(newFont);
        int numPlots = Math.min(this.m_visualizeDataSet.numAttributes(), this.m_maxPlots);
        int gridHeight = numPlots / this.m_gridWidth;
        if (numPlots % this.m_gridWidth != 0) {
            ++gridHeight;
        }
        hp.setLayout(new GridLayout(gridHeight, 4));
        this.m_plots = new ArrayList<AttributeVisualizationPanel>();
        for (int i = 0; i < numPlots; ++i) {
            JPanel temp = new JPanel();
            temp.setLayout(new BorderLayout());
            temp.setBorder(BorderFactory.createTitledBorder(this.m_visualizeDataSet.attribute(i).name()));
            AttributeVisualizationPanel ap = new AttributeVisualizationPanel();
            this.m_plots.add(ap);
            ap.setInstances(this.m_visualizeDataSet);
            if (this.m_coloringIndex < 0 && this.m_visualizeDataSet.classIndex() >= 0) {
                ap.setColoringIndex(this.m_visualizeDataSet.classIndex());
            } else {
                ap.setColoringIndex(this.m_coloringIndex);
            }
            temp.add((Component)ap, "Center");
            ap.setAttribute(i);
            hp.add(temp);
        }
        Dimension d = new Dimension(830, gridHeight * 100);
        hp.setMinimumSize(d);
        hp.setMaximumSize(d);
        hp.setPreferredSize(d);
        JScrollPane scroller = new JScrollPane(hp);
        return scroller;
    }

    @Override
    public void setInstances(Instances inst) throws Exception {
        if (this.m_design) {
            throw new Exception("This method is not to be used during design time. It is meant to be used if this bean is being used programatically as as stand alone component.");
        }
        this.m_visualizeDataSet = inst;
        this.setUpFinal();
    }

    @Override
    public boolean acceptsInstances() {
        return true;
    }

    @Override
    public String getPerspectiveTitle() {
        return "Attribute summary";
    }

    @Override
    public String getPerspectiveTipText() {
        return "Matrix of attribute summary histograms";
    }

    @Override
    public Icon getPerspectiveIcon() {
        Image pic = null;
        URL imageURL = this.getClass().getClassLoader().getResource("weka/gui/beans/icons/chart_bar.png");
        if (imageURL != null) {
            pic = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        return new ImageIcon(pic);
    }

    @Override
    public void setActive(boolean active) {
        this.m_activePerspective = active;
        this.m_plots = null;
        this.setUpFinal();
    }

    @Override
    public void setLoaded(boolean loaded) {
    }

    @Override
    public void setMainKFPerspective(KnowledgeFlowApp.MainKFPerspective main) {
        this.m_showClassCombo = true;
        this.m_runningAsPerspective = true;
    }

    @Override
    public void performRequest(String request) {
        block6: {
            if (!this.m_design) {
                this.setUpFinal();
                return;
            }
            if (request.compareTo("Show summaries") == 0) {
                try {
                    if (!this.m_framePoppedUp) {
                        this.m_framePoppedUp = true;
                        JScrollPane holderP = this.makePanel();
                        final JFrame jf = new JFrame("Visualize");
                        jf.setSize(800, 600);
                        jf.getContentPane().setLayout(new BorderLayout());
                        jf.getContentPane().add((Component)holderP, "Center");
                        jf.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                jf.dispose();
                                AttributeSummarizer.this.m_framePoppedUp = false;
                            }
                        });
                        jf.setVisible(true);
                        this.m_popupFrame = jf;
                        break block6;
                    }
                    this.m_popupFrame.toFront();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.m_framePoppedUp = false;
                }
            } else {
                throw new IllegalArgumentException(request + " not supported (AttributeSummarizer)");
            }
        }
    }

    @Override
    protected void renderOffscreenImage(DataSetEvent e) {
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        if (this.m_imageListeners.size() > 0 && !this.m_processingHeadlessEvents) {
            String[] optionsParts;
            this.setupOffscreenRenderer();
            this.m_offscreenPlotData = new ArrayList();
            Instances predictedI = e.getDataSet();
            if (predictedI.classIndex() >= 0 && predictedI.classAttribute().isNominal()) {
                int i;
                Instances[] classes = new Instances[predictedI.numClasses()];
                for (i = 0; i < predictedI.numClasses(); ++i) {
                    classes[i] = new Instances(predictedI, 0);
                    classes[i].setRelationName(predictedI.classAttribute().value(i));
                }
                for (i = 0; i < predictedI.numInstances(); ++i) {
                    Instance current = predictedI.instance(i);
                    classes[(int)current.classValue()].add((Instance)current.copy());
                }
                for (i = 0; i < classes.length; ++i) {
                    this.m_offscreenPlotData.add(classes[i]);
                }
            } else {
                this.m_offscreenPlotData.add(new Instances(predictedI));
            }
            ArrayList<String> options = new ArrayList<String>();
            String additional = this.m_additionalOptions;
            if (this.m_additionalOptions != null && this.m_additionalOptions.length() > 0) {
                try {
                    additional = this.m_env.substitute(additional);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (additional != null && additional.indexOf("-color") < 0) {
                if (additional.length() > 0) {
                    additional = additional + ",";
                }
                additional = predictedI.classIndex() >= 0 ? additional + "-color=" + predictedI.classAttribute().name() : additional + "-color=/last";
            }
            for (String p : optionsParts = additional.split(",")) {
                options.add(p.trim());
            }
            String xAxis = this.m_xAxis;
            try {
                xAxis = this.m_env.substitute(xAxis);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String width = this.m_width;
            String height = this.m_height;
            int defWidth = 500;
            int defHeight = 400;
            try {
                width = this.m_env.substitute(width);
                height = this.m_env.substitute(height);
                defWidth = Integer.parseInt(width);
                defHeight = Integer.parseInt(height);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                BufferedImage osi = this.m_offscreenRenderer.renderHistogram(defWidth, defHeight, this.m_offscreenPlotData, xAxis, options);
                ImageEvent ie = new ImageEvent(this, osi);
                this.notifyImageListeners(ie);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("Usage: AttributeSummarizer <dataset>");
                System.exit(1);
            }
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            Instances inst = new Instances(r);
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            AttributeSummarizer as = new AttributeSummarizer();
            as.setInstances(inst);
            jf.getContentPane().add((Component)as, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(830, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

