/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.packageManagement;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.pentaho.packageManagement.DefaultPackage;
import org.pentaho.packageManagement.Dependency;
import org.pentaho.packageManagement.Package;
import org.pentaho.packageManagement.PackageConstraint;
import org.pentaho.packageManagement.PackageManager;

public class DefaultPackageManager
extends PackageManager {
    static final int BUFF_SIZE = 100000;
    static final byte[] m_buffer = new byte[100000];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected File downloadPackage(URL packageURL, PrintStream ... progress) throws Exception {
        String packageArchiveName = packageURL.toString();
        packageArchiveName = packageArchiveName.substring(0, packageArchiveName.lastIndexOf(".zip") + 3);
        packageArchiveName = packageArchiveName.substring(0, packageArchiveName.lastIndexOf(46));
        packageArchiveName = packageArchiveName.substring(packageArchiveName.lastIndexOf(47), packageArchiveName.length());
        File tmpDownload = File.createTempFile(packageArchiveName, ".zip");
        for (int i = 0; i < progress.length; ++i) {
            progress[i].println(packageURL.toString());
            progress[i].println("[DefaultPackageManager] Tmp file: " + tmpDownload.toString());
        }
        URLConnection conn = this.getConnection(packageURL);
        BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
        BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(tmpDownload));
        int totalBytesRead = 0;
        while (true) {
            int i;
            byte[] byArray = m_buffer;
            // MONITORENTER : m_buffer
            int amountRead = bi.read(m_buffer);
            if (amountRead == -1) {
                i = 0;
                while (true) {
                    if (i >= progress.length) {
                        // MONITOREXIT : byArray
                        bi.close();
                        bo.close();
                        return tmpDownload;
                    }
                    progress[i].println("[DefaultPackageManager] downloaded " + totalBytesRead / 1000 + " KB");
                    ++i;
                }
            }
            bo.write(m_buffer, 0, amountRead);
            totalBytesRead += amountRead;
            for (i = 0; i < progress.length; ++i) {
                progress[i].println("%%[DefaultPackageManager] downloaded " + totalBytesRead / 1000 + " KB");
            }
            // MONITOREXIT : byArray
        }
    }

    @Override
    public Package getURLPackageInfo(URL packageURL) throws Exception {
        File downloaded = this.downloadPackage(packageURL, new PrintStream[0]);
        return this.getPackageArchiveInfo(downloaded);
    }

    @Override
    public Package getRepositoryPackageInfo(String packageName) throws Exception {
        return this.getRepositoryPackageInfo(packageName, "Latest");
    }

    @Override
    public List<Object> getRepositoryPackageVersions(String packageName) throws Exception {
        String versionNumber;
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String versionsS = this.m_packageRepository.toString() + "/" + packageName + "/" + "versions.txt";
        URL packageURL = new URL(versionsS);
        URLConnection conn = this.getConnection(packageURL);
        BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        ArrayList<Object> versions = new ArrayList<Object>();
        while ((versionNumber = bi.readLine()) != null) {
            versions.add(versionNumber.trim());
        }
        bi.close();
        return versions;
    }

    @Override
    public Package getRepositoryPackageInfo(String packageName, Object version2) throws Exception {
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        if (version2 == null) {
            version2 = "Latest";
        }
        String packageS = this.m_packageRepository.toString() + "/" + packageName + "/" + version2.toString() + ".props";
        URL packageURL = new URL(packageS);
        URLConnection conn = this.getConnection(packageURL);
        BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
        Properties packageProperties = new Properties();
        packageProperties.load(bi);
        bi.close();
        return new DefaultPackage(this.m_packageHome, this, packageProperties);
    }

    private Package getPackageArchiveInfo(File packageArchive) throws Exception {
        return this.getPackageArchiveInfo(packageArchive.getAbsolutePath());
    }

    @Override
    public Package getPackageArchiveInfo(String packageArchivePath) throws Exception {
        ZipFile zip = new ZipFile(new File(packageArchivePath));
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!entry.getName().endsWith("Description.props")) continue;
            InputStream is = zip.getInputStream(entry);
            Properties packageProperties = new Properties();
            packageProperties.load(new BufferedInputStream(is));
            is.close();
            DefaultPackage pkg = new DefaultPackage(this.m_packageHome, this, packageProperties);
            return pkg;
        }
        throw new Exception("Unable to find Description file in package archive!");
    }

    @Override
    public Package getInstalledPackageInfo(String packageName) throws Exception {
        File packageDescription = new File(this.m_packageHome.getAbsoluteFile() + File.separator + packageName + File.separator + "Description.props");
        if (!packageDescription.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(packageDescription);
        Properties packageProperties = new Properties();
        packageProperties.load(fis);
        fis.close();
        DefaultPackage pkg = new DefaultPackage(this.m_packageHome, this, packageProperties);
        return pkg;
    }

    protected boolean establishPackageHome() {
        if (this.m_packageHome == null) {
            return false;
        }
        if (!this.m_packageHome.exists() && !this.m_packageHome.mkdir()) {
            System.err.println("Unable to create packages directory (" + this.m_packageHome.getAbsolutePath() + ")");
            return false;
        }
        return true;
    }

    public static void deleteDir(File dir, PrintStream ... progress) throws Exception {
        File[] contents = dir.listFiles();
        if (contents.length != 0) {
            for (File f : contents) {
                if (f.isDirectory()) {
                    DefaultPackageManager.deleteDir(f, new PrintStream[0]);
                    continue;
                }
                for (int i = 0; i < progress.length; ++i) {
                    progress[i].println("[DefaultPackageManager] removing: " + f.toString());
                }
                if (f.delete()) continue;
                System.err.println("[DefaultPackageManager] can't delete file " + f.toString());
                f.deleteOnExit();
            }
        }
        if (!dir.delete()) {
            System.err.println("[DefaultPackageManager] can't delete directory " + dir.toString());
            dir.deleteOnExit();
        }
        for (int i = 0; i < progress.length; ++i) {
            progress[i].println("[DefaultPackageManager] removing: " + dir.toString());
        }
    }

    @Override
    public void uninstallPackage(String packageName, PrintStream ... progress) throws Exception {
        File packageToDel = new File(this.m_packageHome.toString() + File.separator + packageName);
        if (!packageToDel.exists()) {
            throw new Exception("[DefaultPackageManager] Can't remove " + packageName + " because it doesn't seem to be installed!");
        }
        DefaultPackageManager.deleteDir(packageToDel, progress);
    }

    @Override
    public String installPackageFromArchive(String packageArchivePath, PrintStream ... progress) throws Exception {
        Properties packageProps = (Properties)this.getPackageArchiveInfo(packageArchivePath).getPackageMetaData();
        String packageName = packageProps.getProperty("PackageName");
        if (packageName == null) {
            throw new Exception("Unable to find the name of the package in the Description file for " + packageArchivePath);
        }
        this.installPackage(packageArchivePath, packageName, progress);
        return packageName;
    }

    @Override
    public void installPackages(List<Package> toInstall, PrintStream ... progress) throws Exception {
        int i;
        File[] archivePaths = new File[toInstall.size()];
        for (i = 0; i < toInstall.size(); ++i) {
            Package toDownload = toInstall.get(i);
            archivePaths[i] = this.downloadPackage(toDownload.getPackageURL(), progress);
        }
        for (i = 0; i < archivePaths.length; ++i) {
            this.installPackageFromArchive(archivePaths[i].getAbsolutePath(), progress);
        }
    }

    protected static boolean checkDependencies(PackageConstraint toCheck, Map<String, Dependency> lookup, Map<String, List<Dependency>> conflicts) throws Exception {
        boolean ok = true;
        List<Dependency> deps = toCheck.getPackage().getDependencies();
        for (Dependency p : deps) {
            String depName = p.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString();
            if (!lookup.containsKey(depName)) {
                lookup.put(depName, p);
                ok = DefaultPackageManager.checkDependencies(p.getTarget(), lookup, conflicts);
                continue;
            }
            Dependency checkAgainst = lookup.get(depName);
            PackageConstraint result = checkAgainst.getTarget().checkConstraint(p.getTarget());
            if (result != null) {
                checkAgainst.setTarget(result);
                lookup.put(depName, checkAgainst);
                continue;
            }
            List<Dependency> conflictList = conflicts.get(depName);
            conflictList.add(p);
            ok = false;
        }
        return ok;
    }

    @Override
    public List<Dependency> getAllDependenciesForPackage(Package target, Map<String, List<Dependency>> conflicts) throws Exception {
        List<Dependency> initialList = target.getDependencies();
        HashMap<String, Dependency> lookup = new HashMap<String, Dependency>();
        for (Dependency d : initialList) {
            lookup.put(d.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString(), d);
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            deps.add(d);
            conflicts.put(d.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString(), deps);
        }
        for (Dependency d : initialList) {
            DefaultPackageManager.checkDependencies(d.getTarget(), lookup, conflicts);
        }
        ArrayList<Dependency> fullList = new ArrayList<Dependency>(lookup.values());
        ArrayList<String> removeList = new ArrayList<String>();
        for (String key : conflicts.keySet()) {
            List<Dependency> tempD = conflicts.get(key);
            if (tempD.size() != 1) continue;
            removeList.add(key);
        }
        for (String s : removeList) {
            conflicts.remove(s);
        }
        return fullList;
    }

    @Override
    public void installPackageFromRepository(String packageName, Object version2, PrintStream ... progress) throws Exception {
        Package toInstall = this.getRepositoryPackageInfo(packageName, version2);
        String urlString = toInstall.getPackageMetaDataElement("PackageURL").toString();
        URL packageURL = new URL(urlString);
        this.installPackageFromURL(packageURL, progress);
    }

    @Override
    public String installPackageFromURL(URL packageURL, PrintStream ... progress) throws Exception {
        File downloaded = this.downloadPackage(packageURL, progress);
        return this.installPackageFromArchive(downloaded.getAbsolutePath(), progress);
    }

    private static void copyStreams(InputStream input, OutputStream output) throws IOException {
        int count;
        byte[] data = new byte[1024];
        while ((count = input.read(data, 0, 1024)) != -1) {
            output.write(data, 0, count);
        }
    }

    protected void installPackage(String packageArchivePath, String packageName, PrintStream ... progress) throws Exception {
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to install " + packageArchivePath + " because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        File destDir = new File(this.m_packageHome, packageName);
        if (!destDir.mkdir()) {
            // empty if block
        }
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        ZipFile zipFile = new ZipFile(packageArchivePath);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) {
                new File(destDir, zipEntry.getName()).mkdirs();
                continue;
            }
            File temp = new File(destDir, zipEntry.getName()).getParentFile();
            if (temp != null && !temp.exists()) {
                temp.mkdirs();
            }
            for (int i = 0; i < progress.length; ++i) {
                progress[i].println("[DefaultPackageManager] Installing: " + zipEntry.getName());
            }
            input = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            File destFile = new File(destDir, zipEntry.getName());
            FileOutputStream fos = new FileOutputStream(destFile);
            output = new BufferedOutputStream(fos);
            DefaultPackageManager.copyStreams(input, output);
            ((InputStream)input).close();
            ((OutputStream)output).flush();
            ((OutputStream)output).close();
        }
    }

    private URLConnection getConnection(String urlString) throws IOException {
        URL connURL = new URL(urlString);
        return this.getConnection(connURL);
    }

    private URLConnection getConnection(URL connURL) throws IOException {
        URLConnection conn = null;
        conn = this.setProxyAuthentication(connURL) ? connURL.openConnection(this.m_httpProxy) : connURL.openConnection();
        conn.setConnectTimeout(15000);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void transToBAOS(BufferedInputStream bi, ByteArrayOutputStream bos) throws Exception {
        while (true) {
            byte[] byArray = m_buffer;
            // MONITORENTER : m_buffer
            int amountRead = bi.read(m_buffer);
            if (amountRead == -1) {
                // MONITOREXIT : byArray
                bi.close();
                return;
            }
            bos.write(m_buffer, 0, amountRead);
            // MONITOREXIT : byArray
        }
    }

    private void writeZipEntryForPackage(String packageName, ZipOutputStream zos) throws Exception {
        ZipEntry packageDir = new ZipEntry(packageName + "/");
        zos.putNextEntry(packageDir);
        ZipEntry z = new ZipEntry(packageName + "/Latest.props");
        ZipEntry z2 = new ZipEntry(packageName + "/Latest.html");
        URLConnection conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/Latest.props");
        BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z);
        zos.write(bos.toByteArray());
        conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/Latest.html");
        bi = new BufferedInputStream(conn.getInputStream());
        bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z2);
        zos.write(bos.toByteArray());
        z = new ZipEntry(packageName + "/versions.txt");
        conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/versions.txt");
        bi = new BufferedInputStream(conn.getInputStream());
        bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z);
        zos.write(bos.toByteArray());
        z = new ZipEntry(packageName + "/index.html");
        conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/index.html");
        bi = new BufferedInputStream(conn.getInputStream());
        bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z);
        zos.write(bos.toByteArray());
        List<Object> versions = this.getRepositoryPackageVersions(packageName);
        for (Object o : versions) {
            conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/" + o.toString() + ".props");
            z = new ZipEntry(packageName + "/" + o.toString() + ".props");
            bi = new BufferedInputStream(conn.getInputStream());
            bos = new ByteArrayOutputStream();
            this.transToBAOS(bi, bos);
            zos.putNextEntry(z);
            zos.write(bos.toByteArray());
            conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/" + o.toString() + ".html");
            z = new ZipEntry(packageName + "/" + o.toString() + ".html");
            bi = new BufferedInputStream(conn.getInputStream());
            bos = new ByteArrayOutputStream();
            this.transToBAOS(bi, bos);
            zos.putNextEntry(z);
            zos.write(bos.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getRepositoryPackageMetaDataOnlyAsZip(PrintStream ... progress) throws Exception {
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        try {
            String repoZip = this.m_packageRepository.toString() + "/repo.zip";
            URLConnection conn = null;
            conn = this.getConnection(repoZip);
            BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int totalBytesRead = 0;
            while (true) {
                int i;
                byte[] byArray = m_buffer;
                // MONITORENTER : m_buffer
                int amountRead = bi.read(m_buffer);
                if (amountRead == -1) {
                    i = 0;
                    while (true) {
                        if (i >= progress.length) {
                            // MONITOREXIT : byArray
                            bi.close();
                            return bos.toByteArray();
                        }
                        progress[i].println("[DefaultPackageManager] downloaded " + totalBytesRead / 1000 + " KB");
                        ++i;
                    }
                }
                bos.write(m_buffer, 0, amountRead);
                totalBytesRead += amountRead;
                for (i = 0; i < progress.length; ++i) {
                    progress[i].println("[DefaultPackageManager] downloaded " + totalBytesRead / 1000 + " KB");
                }
                // MONITOREXIT : byArray
            }
        }
        catch (Exception ex) {
            System.err.println("Unable to download repository zip archve (" + ex.getMessage() + ") - trying legacy routine...");
            return this.getRepositoryPackageMetaDataOnlyAsZipLegacy(progress);
        }
    }

    public byte[] getRepositoryPackageMetaDataOnlyAsZipLegacy(PrintStream ... progress) throws Exception {
        String imageName;
        String packageName;
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String packageList = this.m_packageRepository.toString() + "/packageList.txt";
        String packageListWithVersion = this.m_packageRepository.toString() + "/packageListWithVersion.txt";
        URLConnection conn = null;
        conn = this.getConnection(packageList);
        BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        while ((packageName = bi.readLine()) != null) {
            for (PrintStream p : progress) {
                p.println("Fetching meta data for " + packageName);
            }
            this.writeZipEntryForPackage(packageName, zos);
        }
        bi.close();
        conn = this.getConnection(packageList);
        ZipEntry z = new ZipEntry("packageList.txt");
        BufferedInputStream bi2 = new BufferedInputStream(conn.getInputStream());
        ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
        this.transToBAOS(bi2, bos2);
        zos.putNextEntry(z);
        zos.write(bos2.toByteArray());
        bi2.close();
        conn = this.getConnection(packageListWithVersion);
        z = new ZipEntry("packageListWithVersion.txt");
        bi2 = new BufferedInputStream(conn.getInputStream());
        bos2 = new ByteArrayOutputStream();
        this.transToBAOS(bi2, bos2);
        zos.putNextEntry(z);
        zos.write(bos2.toByteArray());
        bi2.close();
        String imageList = this.m_packageRepository.toString() + "/images.txt";
        conn = this.getConnection(imageList);
        bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((imageName = bi.readLine()) != null) {
            z = new ZipEntry(imageName);
            URLConnection conn2 = this.getConnection(this.m_packageRepository.toString() + "/" + imageName);
            bi2 = new BufferedInputStream(conn2.getInputStream());
            bos2 = new ByteArrayOutputStream();
            this.transToBAOS(bi2, bos2);
            zos.putNextEntry(z);
            zos.write(bos2.toByteArray());
            bi2.close();
        }
        conn = this.getConnection(imageList);
        z = new ZipEntry("images.txt");
        bi2 = new BufferedInputStream(conn.getInputStream());
        bos2 = new ByteArrayOutputStream();
        this.transToBAOS(bi2, bos2);
        zos.putNextEntry(z);
        zos.write(bos2.toByteArray());
        bi2.close();
        zos.close();
        return bos.toByteArray();
    }

    @Override
    public List<Package> getAllPackages(PrintStream ... progress) throws Exception {
        String packageName;
        ArrayList<Package> allPackages = new ArrayList<Package>();
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String packageList = this.m_packageRepository.toString() + "/packageList.txt";
        URL packageListURL = new URL(packageList);
        URLConnection conn = this.getConnection(packageListURL);
        BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((packageName = bi.readLine()) != null) {
            Package temp = this.getRepositoryPackageInfo(packageName);
            allPackages.add(temp);
        }
        return allPackages;
    }

    @Override
    public List<Package> getAvailablePackages() throws Exception {
        List<Package> allP = this.getAllPackages(new PrintStream[0]);
        ArrayList<Package> available = new ArrayList<Package>();
        for (int i = 0; i < allP.size(); ++i) {
            if (allP.get(i).isInstalled()) continue;
            available.add(allP.get(i));
        }
        return available;
    }

    @Override
    public List<Package> getInstalledPackages() throws Exception {
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to get list of installed packages because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        ArrayList<Package> installedP = new ArrayList<Package>();
        File[] contents = this.m_packageHome.listFiles();
        for (int i = 0; i < contents.length; ++i) {
            File description;
            if (!contents[i].isDirectory() || !(description = new File(contents[i].getAbsolutePath() + File.separator + "Description.props")).exists()) continue;
            try {
                Properties packageProperties = new Properties();
                BufferedInputStream bi = new BufferedInputStream(new FileInputStream(description));
                packageProperties.load(bi);
                bi.close();
                bi = null;
                DefaultPackage pkg = new DefaultPackage(this.m_packageHome, this, packageProperties);
                installedP.add(pkg);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return installedP;
    }

    protected static String padLeft(String inString, int length) {
        return DefaultPackageManager.fixStringLength(inString, length, false);
    }

    protected static String padRight(String inString, int length) {
        return DefaultPackageManager.fixStringLength(inString, length, true);
    }

    private static String fixStringLength(String inString, int length, boolean right) {
        if (inString.length() < length) {
            while (inString.length() < length) {
                inString = right ? inString.concat(" ") : " ".concat(inString);
            }
        } else if (inString.length() > length) {
            inString = inString.substring(0, length);
        }
        return inString;
    }

    public static void main(String[] args) {
        try {
            URL url = new URL(args[0]);
            DefaultPackageManager pm = new DefaultPackageManager();
            pm.downloadPackage(url, System.out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

