/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation.assignability;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.jboss.aop.advice.annotation.assignability.ParamTypeAssignabilityAlgorithm;
import org.jboss.aop.advice.annotation.assignability.VariableHierarchy;
import org.jboss.aop.advice.annotation.assignability.VariableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AssignabilityAlgorithm {
    VARIABLE_TARGET{

        protected AssignabilityAlgorithm getInverseAlgorithm() {
            return FROM_VARIABLE;
        }

        protected boolean isVariableOperationApplicable(Type type2, Type fromType) {
            return type2 instanceof TypeVariable;
        }

        protected boolean assignValue(Type type2, Type fromType, VariableHierarchy variableHierarchy) {
            VariableNode node = variableHierarchy.getVariableNode((TypeVariable)type2);
            return node.assignValue(fromType);
        }

        protected boolean addBound(Type type2, Type fromType, VariableHierarchy variableHierarchy) {
            VariableNode node = variableHierarchy.getVariableNode((TypeVariable)type2);
            return node.addLowerBound(fromType);
        }
    }
    ,
    FROM_VARIABLE{

        protected AssignabilityAlgorithm getInverseAlgorithm() {
            return VARIABLE_TARGET;
        }

        protected boolean isVariableOperationApplicable(Type type2, Type fromType) {
            return fromType instanceof TypeVariable;
        }

        protected boolean assignValue(Type type2, Type fromType, VariableHierarchy variableHierarchy) {
            VariableNode fromNode = variableHierarchy.getVariableNode((TypeVariable)fromType);
            return fromNode.addMaximumUpperBound(type2);
        }

        protected boolean addBound(Type type2, Type fromType, VariableHierarchy variableHierarchy) {
            VariableNode fromNode = variableHierarchy.getVariableNode((TypeVariable)fromType);
            return fromNode.addUpperBound(type2);
        }
    };

    private static final ParamTypeAssignabilityAlgorithm.EqualityChecker<AssignabilityAlgorithm, VariableHierarchy> CHECKER;

    protected abstract boolean assignValue(Type var1, Type var2, VariableHierarchy var3);

    protected abstract AssignabilityAlgorithm getInverseAlgorithm();

    public boolean isAssignable(Type type2, Type fromType, VariableHierarchy variableHierarchy) {
        if (fromType instanceof WildcardType) {
            return this.isAssignable(type2, (WildcardType)fromType, variableHierarchy);
        }
        if (this.isVariableOperationApplicable(type2, fromType)) {
            return this.addBound(type2, fromType, variableHierarchy);
        }
        if (type2 instanceof Class) {
            return this.isAssignable((Class)type2, fromType, variableHierarchy);
        }
        if (type2 instanceof ParameterizedType) {
            return this.isAssignable((ParameterizedType)type2, fromType, variableHierarchy);
        }
        if (type2 instanceof WildcardType) {
            throw new RuntimeException("This comparison should never happen");
        }
        if (type2 instanceof TypeVariable) {
            return false;
        }
        return this.isAssignable((GenericArrayType)type2, fromType, variableHierarchy);
    }

    protected abstract boolean isVariableOperationApplicable(Type var1, Type var2);

    protected abstract boolean addBound(Type var1, Type var2, VariableHierarchy var3);

    private boolean isAssignable(Type type2, WildcardType fromWildcardType, VariableHierarchy variableHierarchy) {
        boolean boundOk = false;
        for (Type upperBound : fromWildcardType.getUpperBounds()) {
            if (!this.isAssignable(type2, upperBound, variableHierarchy)) continue;
            boundOk = true;
            break;
        }
        if (!boundOk) {
            return false;
        }
        for (Type lowerBound : fromWildcardType.getLowerBounds()) {
            if (!this.isAssignable(type2, lowerBound, variableHierarchy)) continue;
            return true;
        }
        return fromWildcardType.getLowerBounds().length == 0;
    }

    private boolean isAssignable(Class<?> classType, Type fromType, VariableHierarchy variableHierarchy) {
        if (fromType instanceof Class) {
            return classType.isAssignableFrom((Class)fromType);
        }
        if (fromType instanceof ParameterizedType) {
            return classType.isAssignableFrom((Class)((ParameterizedType)fromType).getRawType());
        }
        if (fromType instanceof TypeVariable) {
            Type[] bounds = AssignabilityAlgorithm.getConcreteBounds(fromType);
            boolean inside = false;
            for (int i = 0; i < bounds.length && !inside; ++i) {
                if (bounds[i] instanceof Class) {
                    if (!classType.isAssignableFrom((Class)bounds[i])) continue;
                    inside = true;
                    continue;
                }
                if (!classType.isAssignableFrom((Class)((ParameterizedType)bounds[i]).getRawType())) continue;
                inside = true;
            }
            return inside;
        }
        if (classType == Object.class) {
            return true;
        }
        if (classType.isArray()) {
            return this.isAssignable(classType.getComponentType(), ((GenericArrayType)fromType).getGenericComponentType(), variableHierarchy);
        }
        return false;
    }

    public static Type[] getConcreteBounds(Type type2) {
        TypeVariable current = (TypeVariable)type2;
        Type[] bounds = current.getBounds();
        while (bounds.length == 1 && bounds[0] instanceof TypeVariable) {
            current = (TypeVariable)bounds[0];
            bounds = current.getBounds();
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAssignable(ParameterizedType paramType, Type fromType, VariableHierarchy variableHierarchy) {
        if (fromType instanceof TypeVariable) {
            Type[] concreteBounds = AssignabilityAlgorithm.getConcreteBounds((TypeVariable)fromType);
            try {
                variableHierarchy.startRealBoundComparation();
                for (int i = 0; i < concreteBounds.length; ++i) {
                    if (!this.isAssignable(paramType, concreteBounds[i], variableHierarchy)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                variableHierarchy.finishRealBoundComparation();
            }
            return false;
        }
        return ParamTypeAssignabilityAlgorithm.isAssignable(paramType, fromType, CHECKER, this, variableHierarchy);
    }

    private boolean isAssignable(GenericArrayType arrayType, Type fromType, VariableHierarchy variableHierarchy) {
        if (fromType instanceof Class) {
            Class fromClass = (Class)fromType;
            if (!fromClass.isArray()) {
                return false;
            }
            return this.isAssignable(arrayType.getGenericComponentType(), fromClass.getComponentType(), variableHierarchy);
        }
        if (fromType instanceof GenericArrayType) {
            GenericArrayType fromArrayType = (GenericArrayType)fromType;
            return this.isAssignable(arrayType.getGenericComponentType(), fromArrayType.getGenericComponentType(), variableHierarchy);
        }
        return false;
    }

    static {
        CHECKER = new ParamTypeAssignabilityAlgorithm.EqualityChecker<AssignabilityAlgorithm, VariableHierarchy>(){

            @Override
            public boolean isSame(Type type2, Type fromType, AssignabilityAlgorithm client, VariableHierarchy variableHierarchy) {
                if (client.isVariableOperationApplicable(type2, fromType)) {
                    return client.assignValue(type2, fromType, variableHierarchy);
                }
                if (type2 instanceof Class) {
                    Class fromClass;
                    if (fromType instanceof Class) {
                        fromClass = (Class)fromType;
                    } else if (fromType instanceof ParameterizedType) {
                        fromClass = (Class)((ParameterizedType)fromType).getRawType();
                    } else {
                        return false;
                    }
                    return ((Class)type2).isAssignableFrom(fromClass);
                }
                if (type2 instanceof ParameterizedType) {
                    if (!(fromType instanceof ParameterizedType)) {
                        return false;
                    }
                    ParameterizedType fromParamType = (ParameterizedType)fromType;
                    ParameterizedType paramType = (ParameterizedType)type2;
                    if (!this.isSame(paramType.getRawType(), fromParamType.getRawType(), client, variableHierarchy)) {
                        return false;
                    }
                    return this.isSame(paramType.getActualTypeArguments(), fromParamType.getActualTypeArguments(), client, variableHierarchy);
                }
                if (type2 instanceof WildcardType) {
                    int i;
                    Type[] upperBounds = ((WildcardType)type2).getUpperBounds();
                    Type[] lowerBounds = ((WildcardType)type2).getLowerBounds();
                    if (fromType instanceof WildcardType) {
                        Type[] fromUpperBounds = ((WildcardType)fromType).getUpperBounds();
                        block0: for (int i2 = 0; i2 < upperBounds.length; ++i2) {
                            for (int j = 0; j < fromUpperBounds.length; ++j) {
                                if (client.isAssignable(upperBounds[i2], fromUpperBounds[i2], variableHierarchy)) continue block0;
                            }
                            return false;
                        }
                        Type[] fromLowerBounds = ((WildcardType)fromType).getLowerBounds();
                        block2: for (int i3 = 0; i3 < lowerBounds.length; ++i3) {
                            for (int j = 0; j < fromLowerBounds.length; ++j) {
                                if (client.getInverseAlgorithm().isAssignable(fromLowerBounds[i3], lowerBounds[i3], variableHierarchy)) continue block2;
                            }
                            return false;
                        }
                        return true;
                    }
                    for (i = 0; i < upperBounds.length; ++i) {
                        if (client.isAssignable(upperBounds[i], fromType, variableHierarchy)) continue;
                        return false;
                    }
                    for (i = 0; i < lowerBounds.length; ++i) {
                        if (client.getInverseAlgorithm().isAssignable(fromType, lowerBounds[i], variableHierarchy)) continue;
                        return false;
                    }
                    return true;
                }
                return true;
            }
        };
    }
}

