/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.Serializable;
import org.ejml.data.MatrixIterator;

public abstract class Matrix64F
implements Serializable {
    private static final long serialVersionUID = 423423451942L;
    public int numRows;
    public int numCols;

    public abstract void reshape(int var1, int var2, boolean var3);

    public void reshape(int numRows, int numCols) {
        this.reshape(numRows, numCols, false);
    }

    public abstract double get(int var1, int var2);

    public abstract double unsafe_get(int var1, int var2);

    public abstract void set(int var1, int var2, double var3);

    public abstract void unsafe_set(int var1, int var2, double var3);

    public MatrixIterator iterator(boolean rowMajor, int minRow, int minCol, int maxRow, int maxCol) {
        return new MatrixIterator(this, rowMajor, minRow, minCol, maxRow, maxCol);
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public abstract int getNumElements();

    public void set(Matrix64F A) {
        if (A.numRows != this.numRows) {
            throw new IllegalArgumentException("Unexpected number of rows.");
        }
        if (A.numCols != this.numCols) {
            throw new IllegalArgumentException("Unexpected number of columns.");
        }
        for (int i = 0; i < A.numRows; ++i) {
            for (int j = 0; j < A.numCols; ++j) {
                this.set(i, j, A.get(i, j));
            }
        }
    }

    public abstract <T extends Matrix64F> T copy();

    public abstract void print();
}

