/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.exception.Nestable;

public class NestableDelegate
implements Serializable {
    private static final transient String MUST_BE_THROWABLE = "The Nestable implementation passed to the NestableDelegate(Nestable) constructor must extend java.lang.Throwable";
    private Throwable nestable = null;
    public static boolean topDown = true;
    public static boolean trimStackFrames = true;
    public static boolean matchSubclasses = true;
    static /* synthetic */ Class class$org$apache$commons$lang$exception$Nestable;

    public NestableDelegate(Nestable nestable) {
        if (!(nestable instanceof Throwable)) {
            throw new IllegalArgumentException(MUST_BE_THROWABLE);
        }
        this.nestable = (Throwable)((Object)nestable);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getMessage(int index) {
        Throwable t;
        if ((class$org$apache$commons$lang$exception$Nestable != null ? class$org$apache$commons$lang$exception$Nestable : (class$org$apache$commons$lang$exception$Nestable = NestableDelegate.class$("org.apache.commons.lang.exception.Nestable"))).isInstance(t = this.getThrowable(index))) {
            return ((Nestable)((Object)t)).getMessage(0);
        }
        return t.getMessage();
    }

    public String getMessage(String baseMsg) {
        String causeMsg;
        Throwable nestedCause;
        StringBuffer msg = new StringBuffer();
        if (baseMsg != null) {
            msg.append(baseMsg);
        }
        if ((nestedCause = ExceptionUtils.getCause(this.nestable)) != null && (causeMsg = nestedCause.getMessage()) != null) {
            if (baseMsg != null) {
                msg.append(": ");
            }
            msg.append(causeMsg);
        }
        return msg.length() > 0 ? msg.toString() : null;
    }

    public String[] getMessages() {
        Throwable[] throwables = this.getThrowables();
        String[] msgs = new String[throwables.length];
        int i = 0;
        while (i < throwables.length) {
            msgs[i] = (class$org$apache$commons$lang$exception$Nestable != null ? class$org$apache$commons$lang$exception$Nestable : NestableDelegate.class$("org.apache.commons.lang.exception.Nestable")).isInstance(throwables[i]) ? ((Nestable)((Object)throwables[i])).getMessage(0) : throwables[i].getMessage();
            ++i;
        }
        return msgs;
    }

    protected String[] getStackFrames(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        if (t instanceof Nestable) {
            ((Nestable)((Object)t)).printPartialStackTrace(pw);
        } else {
            t.printStackTrace(pw);
        }
        return ExceptionUtils.getStackFrames(sw.getBuffer().toString());
    }

    public Throwable getThrowable(int index) {
        if (index == 0) {
            return this.nestable;
        }
        Throwable[] throwables = this.getThrowables();
        return throwables[index];
    }

    public int getThrowableCount() {
        return ExceptionUtils.getThrowableCount(this.nestable);
    }

    public Throwable[] getThrowables() {
        return ExceptionUtils.getThrowables(this.nestable);
    }

    public int indexOfThrowable(Class type2, int fromIndex) {
        if (type2 == null) {
            return -1;
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("The start index was out of bounds: " + fromIndex);
        }
        Throwable[] throwables = ExceptionUtils.getThrowables(this.nestable);
        if (fromIndex >= throwables.length) {
            throw new IndexOutOfBoundsException("The start index was out of bounds: " + fromIndex + " >= " + throwables.length);
        }
        if (matchSubclasses) {
            int i = fromIndex;
            while (i < throwables.length) {
                if (type2.isAssignableFrom(throwables[i].getClass())) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = fromIndex;
            while (i < throwables.length) {
                if (type2.equals(throwables[i].getClass())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(out, false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    public void printStackTrace(PrintWriter out) {
        Throwable throwable = this.nestable;
        if (ExceptionUtils.isThrowableNested()) {
            if (throwable instanceof Nestable) {
                ((Nestable)((Object)throwable)).printPartialStackTrace(out);
            } else {
                throwable.printStackTrace(out);
            }
            return;
        }
        ArrayList<String[]> stacks = new ArrayList<String[]>();
        while (throwable != null) {
            String[] st = this.getStackFrames(throwable);
            stacks.add(st);
            throwable = ExceptionUtils.getCause(throwable);
        }
        String separatorLine = "Caused by: ";
        if (!topDown) {
            separatorLine = "Rethrown as: ";
            Collections.reverse(stacks);
        }
        if (trimStackFrames) {
            this.trimStackFrames(stacks);
        }
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            Iterator iter = stacks.iterator();
            while (iter.hasNext()) {
                String[] st = (String[])iter.next();
                int i = 0;
                int len = st.length;
                while (i < len) {
                    out.println(st[i]);
                    ++i;
                }
                if (!iter.hasNext()) continue;
                out.print(separatorLine);
            }
        }
    }

    protected void trimStackFrames(List stacks) {
        int size = stacks.size();
        int i = size - 1;
        while (i > 0) {
            String[] curr = (String[])stacks.get(i);
            String[] next = (String[])stacks.get(i - 1);
            ArrayList<String> currList = new ArrayList<String>(Arrays.asList(curr));
            ArrayList<String> nextList = new ArrayList<String>(Arrays.asList(next));
            ExceptionUtils.removeCommonFrames(currList, nextList);
            int trimmed = curr.length - currList.size();
            if (trimmed > 0) {
                currList.add("\t... " + trimmed + " more");
                stacks.set(i, currList.toArray(new String[currList.size()]));
            }
            --i;
        }
    }
}

