/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.bidimap;

import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.KeyValue;
import org.apache.commons.collections15.MapIterator;
import org.apache.commons.collections15.OrderedBidiMap;
import org.apache.commons.collections15.OrderedIterator;
import org.apache.commons.collections15.OrderedMapIterator;
import org.apache.commons.collections15.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections15.keyvalue.UnmodifiableMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBidiMap<K extends Comparable, V extends Comparable>
implements OrderedBidiMap<K, V> {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int MAPENTRY = 2;
    private static final int INVERSEMAPENTRY = 3;
    private static final int SUM_OF_INDICES = 1;
    private static final int FIRST_INDEX = 0;
    private static final int NUMBER_OF_INDICES = 2;
    private static final String[] dataName = new String[]{"key", "value"};
    private Node<K, V>[] rootNode = new Node[2];
    private int nodeCount = 0;
    private int modifications = 0;
    private Set<K> keySet;
    private Set<V> valuesSet;
    private Set entrySet;
    private Inverse<K, V> inverse = null;

    public TreeBidiMap() {
    }

    public TreeBidiMap(Map map) {
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.nodeCount;
    }

    @Override
    public boolean isEmpty() {
        return this.nodeCount == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        TreeBidiMap.checkKey(key);
        return this.lookup((Comparable)key, 0) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        TreeBidiMap.checkValue(value);
        return this.lookup((Comparable)value, 1) != null;
    }

    @Override
    public V get(Object key) {
        return this.doGetValue(key);
    }

    @Override
    public V put(K key, V value) {
        return this.doPutByKey(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put((K)((Comparable)entry.getKey()), (V)((Comparable)entry.getValue()));
        }
    }

    @Override
    public V remove(Object key) {
        return this.doRemoveByKey((Comparable)key);
    }

    @Override
    public void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[0] = null;
        this.rootNode[1] = null;
    }

    @Override
    public K getKey(Object value) {
        return this.doGetKey((Comparable)value);
    }

    @Override
    public K removeValue(Object value) {
        return this.doRemoveByValue((Comparable)value);
    }

    @Override
    public K firstKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return (K)TreeBidiMap.leastNode(this.rootNode[0], 0).getKey();
    }

    @Override
    public K lastKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return (K)TreeBidiMap.greatestNode(this.rootNode[0], 0).getKey();
    }

    @Override
    public K nextKey(K key) {
        TreeBidiMap.checkKey(key);
        Node<K, V> node = this.nextGreater(this.lookup((Comparable)key, 0), 0);
        return (K)(node == null ? null : node.getKey());
    }

    @Override
    public K previousKey(K key) {
        TreeBidiMap.checkKey(key);
        Node<K, V> node = this.nextSmaller(this.lookup((Comparable)key, 0), 0);
        return (K)(node == null ? null : node.getKey());
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new View(this, 0, 0);
        }
        return this.keySet;
    }

    @Override
    public Set<V> values() {
        if (this.valuesSet == null) {
            this.valuesSet = new View(this, 0, 1);
        }
        return this.valuesSet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            return new EntryView(this, 0, 2);
        }
        return this.entrySet;
    }

    @Override
    public MapIterator<K, V> mapIterator() {
        if (this.isEmpty()) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new ViewMapIterator(this, 0);
    }

    @Override
    public OrderedMapIterator<K, V> orderedMapIterator() {
        if (this.isEmpty()) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new ViewMapIterator(this, 0);
    }

    @Override
    public BidiMap<V, K> inverseBidiMap() {
        return this.inverseOrderedBidiMap();
    }

    @Override
    public OrderedBidiMap<V, K> inverseOrderedBidiMap() {
        if (this.inverse == null) {
            this.inverse = new Inverse(this);
        }
        return this.inverse;
    }

    @Override
    public boolean equals(Object obj) {
        return this.doEquals(obj, 0);
    }

    @Override
    public int hashCode() {
        return this.doHashCode(0);
    }

    public String toString() {
        return this.doToString(0);
    }

    private K doGetKey(Comparable value) {
        TreeBidiMap.checkNonNullComparable(value);
        Node<K, V> node = this.lookup(value, 1);
        if (node == null) {
            return null;
        }
        return (K)node.getKey();
    }

    private V doGetValue(Object key) {
        TreeBidiMap.checkNonNullComparable(key);
        Node<K, V> node = this.lookup((Comparable)key, 0);
        if (node == null) {
            return null;
        }
        return (V)node.getValue();
    }

    private V doPutByKey(K key, V value) {
        TreeBidiMap.checkKeyAndValue(key, value);
        V prev = this.doGetValue(key);
        this.doPut(key, value);
        return prev;
    }

    private K doPutByValue(K key, V value) {
        TreeBidiMap.checkKeyAndValue(key, value);
        K prev = this.doGetKey((Comparable)value);
        this.doPut(key, value);
        return prev;
    }

    private void doPut(K key, V value) {
        block6: {
            this.doRemoveByKey(key);
            this.doRemoveByValue((Comparable)value);
            Node node = this.rootNode[0];
            if (node == null) {
                Node<K, V> root = new Node<K, V>(key, value);
                this.rootNode[0] = root;
                this.rootNode[1] = root;
                this.grow();
            } else {
                while (true) {
                    int cmp;
                    if ((cmp = TreeBidiMap.compare(key, (Comparable)node.getKey())) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + key + "\") in this Map");
                    }
                    if (cmp < 0) {
                        if (node.getLeft(0) != null) {
                            node = node.getLeft(0);
                            continue;
                        }
                        Node<K, V> newNode = new Node<K, V>(key, value);
                        this.insertValue(newNode);
                        node.setLeft((Node)newNode, 0);
                        ((Node)newNode).setParent(node, 0);
                        this.doRedBlackInsert(newNode, 0);
                        this.grow();
                        break block6;
                    }
                    if (node.getRight(0) == null) break;
                    node = node.getRight(0);
                }
                Node<K, V> newNode = new Node<K, V>(key, value);
                this.insertValue(newNode);
                node.setRight((Node)newNode, 0);
                ((Node)newNode).setParent(node, 0);
                this.doRedBlackInsert(newNode, 0);
                this.grow();
            }
        }
    }

    private V doRemoveByKey(K key) {
        Node<K, V> node = this.lookup((Comparable)key, 0);
        Object rval = null;
        if (node != null) {
            rval = node.getValue();
            this.doRedBlackDelete(node);
        }
        return (V)rval;
    }

    private K doRemoveByValue(Comparable value) {
        Node<K, V> node = this.lookup(value, 1);
        Object rval = null;
        if (node != null) {
            rval = node.getKey();
            this.doRedBlackDelete(node);
        }
        return (K)rval;
    }

    private Node<K, V> lookup(Comparable data, int index) {
        Node rval = null;
        Node node = this.rootNode[index];
        while (node != null) {
            int cmp = TreeBidiMap.compare(data, node.getData(index));
            if (cmp == 0) {
                rval = node;
                break;
            }
            node = cmp < 0 ? node.getLeft(index) : node.getRight(index);
        }
        return rval;
    }

    private Node<K, V> nextGreater(Node<K, V> node, int index) {
        Node rval = null;
        if (node == null) {
            rval = null;
        } else if (node.getRight(index) != null) {
            rval = TreeBidiMap.leastNode(node.getRight(index), index);
        } else {
            Node parent = node.getParent(index);
            Node child = node;
            while (parent != null && child == parent.getRight(index)) {
                child = parent;
                parent = parent.getParent(index);
            }
            rval = parent;
        }
        return rval;
    }

    private Node<K, V> nextSmaller(Node<K, V> node, int index) {
        Node rval = null;
        if (node == null) {
            rval = null;
        } else if (node.getLeft(index) != null) {
            rval = TreeBidiMap.greatestNode(node.getLeft(index), index);
        } else {
            Node parent = node.getParent(index);
            Node child = node;
            while (parent != null && child == parent.getLeft(index)) {
                child = parent;
                parent = parent.getParent(index);
            }
            rval = parent;
        }
        return rval;
    }

    private static int oppositeIndex(int index) {
        return 1 - index;
    }

    private static int compare(Comparable o1, Comparable o2) {
        return o1.compareTo(o2);
    }

    private static <K extends Comparable, V extends Comparable> Node<K, V> leastNode(Node<K, V> node, int index) {
        Node rval = node;
        if (rval != null) {
            while (rval.getLeft(index) != null) {
                rval = rval.getLeft(index);
            }
        }
        return rval;
    }

    private static <K extends Comparable, V extends Comparable> Node<K, V> greatestNode(Node<K, V> node, int index) {
        Node rval = node;
        if (rval != null) {
            while (rval.getRight(index) != null) {
                rval = rval.getRight(index);
            }
        }
        return rval;
    }

    private static void copyColor(Node from, Node to, int index) {
        if (to != null) {
            if (from == null) {
                to.setBlack(index);
            } else {
                to.copyColor(from, index);
            }
        }
    }

    private static boolean isRed(Node node, int index) {
        return node == null ? false : node.isRed(index);
    }

    private static boolean isBlack(Node node, int index) {
        return node == null ? true : node.isBlack(index);
    }

    private static void makeRed(Node node, int index) {
        if (node != null) {
            node.setRed(index);
        }
    }

    private static <K extends Comparable, V extends Comparable> void makeBlack(Node<K, V> node, int index) {
        if (node != null) {
            ((Node)node).setBlack(index);
        }
    }

    private static <K extends Comparable, V extends Comparable> Node<K, V> getGrandParent(Node<K, V> node, int index) {
        return TreeBidiMap.getParent(TreeBidiMap.getParent(node, index), index);
    }

    private static <K extends Comparable, V extends Comparable> Node<K, V> getParent(Node<K, V> node, int index) {
        return node == null ? null : ((Node)node).getParent(index);
    }

    private static <K extends Comparable, V extends Comparable> Node<K, V> getRightChild(Node<K, V> node, int index) {
        return node == null ? null : ((Node)node).getRight(index);
    }

    private static <K extends Comparable, V extends Comparable> Node<K, V> getLeftChild(Node<K, V> node, int index) {
        return node == null ? null : ((Node)node).getLeft(index);
    }

    private static <K extends Comparable, V extends Comparable> boolean isLeftChild(Node<K, V> node, int index) {
        return node == null ? true : (((Node)node).getParent(index) == null ? false : node == ((Node)((Node)node).getParent(index)).getLeft(index));
    }

    private static <K extends Comparable, V extends Comparable> boolean isRightChild(Node<K, V> node, int index) {
        return node == null ? true : (((Node)node).getParent(index) == null ? false : node == ((Node)((Node)node).getParent(index)).getRight(index));
    }

    private void rotateLeft(Node<K, V> node, int index) {
        Node rightChild = ((Node)node).getRight(index);
        ((Node)node).setRight((Node)rightChild.getLeft(index), index);
        if (rightChild.getLeft(index) != null) {
            ((Node)rightChild.getLeft(index)).setParent((Node)node, index);
        }
        rightChild.setParent((Node)((Node)node).getParent(index), index);
        if (((Node)node).getParent(index) == null) {
            this.rootNode[index] = rightChild;
        } else if (((Node)((Node)node).getParent(index)).getLeft(index) == node) {
            ((Node)((Node)node).getParent(index)).setLeft(rightChild, index);
        } else {
            ((Node)((Node)node).getParent(index)).setRight(rightChild, index);
        }
        rightChild.setLeft((Node)node, index);
        ((Node)node).setParent(rightChild, index);
    }

    private void rotateRight(Node<K, V> node, int index) {
        Node leftChild = ((Node)node).getLeft(index);
        ((Node)node).setLeft((Node)leftChild.getRight(index), index);
        if (leftChild.getRight(index) != null) {
            ((Node)leftChild.getRight(index)).setParent((Node)node, index);
        }
        leftChild.setParent((Node)((Node)node).getParent(index), index);
        if (((Node)node).getParent(index) == null) {
            this.rootNode[index] = leftChild;
        } else if (((Node)((Node)node).getParent(index)).getRight(index) == node) {
            ((Node)((Node)node).getParent(index)).setRight(leftChild, index);
        } else {
            ((Node)((Node)node).getParent(index)).setLeft(leftChild, index);
        }
        leftChild.setRight((Node)node, index);
        ((Node)node).setParent(leftChild, index);
    }

    private void doRedBlackInsert(Node<K, V> insertedNode, int index) {
        Node<K, V> currentNode = insertedNode;
        TreeBidiMap.makeRed(currentNode, index);
        while (currentNode != null && currentNode != this.rootNode[index] && TreeBidiMap.isRed(((Node)currentNode).getParent(index), index)) {
            Node<K, V> y;
            if (TreeBidiMap.isLeftChild(TreeBidiMap.getParent(currentNode, index), index)) {
                y = TreeBidiMap.getRightChild(TreeBidiMap.getGrandParent(currentNode, index), index);
                if (TreeBidiMap.isRed(y, index)) {
                    TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index), index);
                    TreeBidiMap.makeBlack(y, index);
                    TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index), index);
                    currentNode = TreeBidiMap.getGrandParent(currentNode, index);
                    continue;
                }
                if (TreeBidiMap.isRightChild(currentNode, index)) {
                    currentNode = TreeBidiMap.getParent(currentNode, index);
                    this.rotateLeft(currentNode, index);
                }
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index), index);
                TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index), index);
                if (TreeBidiMap.getGrandParent(currentNode, index) == null) continue;
                this.rotateRight(TreeBidiMap.getGrandParent(currentNode, index), index);
                continue;
            }
            y = TreeBidiMap.getLeftChild(TreeBidiMap.getGrandParent(currentNode, index), index);
            if (TreeBidiMap.isRed(y, index)) {
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index), index);
                TreeBidiMap.makeBlack(y, index);
                TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index), index);
                currentNode = TreeBidiMap.getGrandParent(currentNode, index);
                continue;
            }
            if (TreeBidiMap.isLeftChild(currentNode, index)) {
                currentNode = TreeBidiMap.getParent(currentNode, index);
                this.rotateRight(currentNode, index);
            }
            TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index), index);
            TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index), index);
            if (TreeBidiMap.getGrandParent(currentNode, index) == null) continue;
            this.rotateLeft(TreeBidiMap.getGrandParent(currentNode, index), index);
        }
        TreeBidiMap.makeBlack(this.rootNode[index], index);
    }

    private void doRedBlackDelete(Node<K, V> deletedNode) {
        for (int index = 0; index < 2; ++index) {
            Node replacement;
            if (((Node)deletedNode).getLeft(index) != null && ((Node)deletedNode).getRight(index) != null) {
                this.swapPosition(this.nextGreater(deletedNode, index), deletedNode, index);
            }
            Node node = replacement = ((Node)deletedNode).getLeft(index) != null ? ((Node)deletedNode).getLeft(index) : ((Node)deletedNode).getRight(index);
            if (replacement != null) {
                replacement.setParent((Node)((Node)deletedNode).getParent(index), index);
                if (((Node)deletedNode).getParent(index) == null) {
                    this.rootNode[index] = replacement;
                } else if (deletedNode == ((Node)((Node)deletedNode).getParent(index)).getLeft(index)) {
                    ((Node)((Node)deletedNode).getParent(index)).setLeft(replacement, index);
                } else {
                    ((Node)((Node)deletedNode).getParent(index)).setRight(replacement, index);
                }
                ((Node)deletedNode).setLeft(null, index);
                ((Node)deletedNode).setRight(null, index);
                ((Node)deletedNode).setParent(null, index);
                if (!TreeBidiMap.isBlack(deletedNode, index)) continue;
                this.doRedBlackDeleteFixup(replacement, index);
                continue;
            }
            if (((Node)deletedNode).getParent(index) == null) {
                this.rootNode[index] = null;
                continue;
            }
            if (TreeBidiMap.isBlack(deletedNode, index)) {
                this.doRedBlackDeleteFixup(deletedNode, index);
            }
            if (((Node)deletedNode).getParent(index) == null) continue;
            if (deletedNode == ((Node)((Node)deletedNode).getParent(index)).getLeft(index)) {
                ((Node)((Node)deletedNode).getParent(index)).setLeft(null, index);
            } else {
                ((Node)((Node)deletedNode).getParent(index)).setRight(null, index);
            }
            ((Node)deletedNode).setParent(null, index);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node<K, V> replacementNode, int index) {
        Node<K, V> currentNode = replacementNode;
        while (currentNode != this.rootNode[index] && TreeBidiMap.isBlack(currentNode, index)) {
            Node<K, V> siblingNode;
            if (TreeBidiMap.isLeftChild(currentNode, index)) {
                siblingNode = TreeBidiMap.getRightChild(TreeBidiMap.getParent(currentNode, index), index);
                if (TreeBidiMap.isRed(siblingNode, index)) {
                    TreeBidiMap.makeBlack(siblingNode, index);
                    TreeBidiMap.makeRed(TreeBidiMap.getParent(currentNode, index), index);
                    this.rotateLeft(TreeBidiMap.getParent(currentNode, index), index);
                    siblingNode = TreeBidiMap.getRightChild(TreeBidiMap.getParent(currentNode, index), index);
                }
                if (TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(siblingNode, index), index) && TreeBidiMap.isBlack(TreeBidiMap.getRightChild(siblingNode, index), index)) {
                    TreeBidiMap.makeRed(siblingNode, index);
                    currentNode = TreeBidiMap.getParent(currentNode, index);
                    continue;
                }
                if (TreeBidiMap.isBlack(TreeBidiMap.getRightChild(siblingNode, index), index)) {
                    TreeBidiMap.makeBlack(TreeBidiMap.getLeftChild(siblingNode, index), index);
                    TreeBidiMap.makeRed(siblingNode, index);
                    this.rotateRight(siblingNode, index);
                    siblingNode = TreeBidiMap.getRightChild(TreeBidiMap.getParent(currentNode, index), index);
                }
                TreeBidiMap.copyColor(TreeBidiMap.getParent(currentNode, index), siblingNode, index);
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index), index);
                TreeBidiMap.makeBlack(TreeBidiMap.getRightChild(siblingNode, index), index);
                this.rotateLeft(TreeBidiMap.getParent(currentNode, index), index);
                currentNode = this.rootNode[index];
                continue;
            }
            siblingNode = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(currentNode, index), index);
            if (TreeBidiMap.isRed(siblingNode, index)) {
                TreeBidiMap.makeBlack(siblingNode, index);
                TreeBidiMap.makeRed(TreeBidiMap.getParent(currentNode, index), index);
                this.rotateRight(TreeBidiMap.getParent(currentNode, index), index);
                siblingNode = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(currentNode, index), index);
            }
            if (TreeBidiMap.isBlack(TreeBidiMap.getRightChild(siblingNode, index), index) && TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(siblingNode, index), index)) {
                TreeBidiMap.makeRed(siblingNode, index);
                currentNode = TreeBidiMap.getParent(currentNode, index);
                continue;
            }
            if (TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(siblingNode, index), index)) {
                TreeBidiMap.makeBlack(TreeBidiMap.getRightChild(siblingNode, index), index);
                TreeBidiMap.makeRed(siblingNode, index);
                this.rotateLeft(siblingNode, index);
                siblingNode = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(currentNode, index), index);
            }
            TreeBidiMap.copyColor(TreeBidiMap.getParent(currentNode, index), siblingNode, index);
            TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index), index);
            TreeBidiMap.makeBlack(TreeBidiMap.getLeftChild(siblingNode, index), index);
            this.rotateRight(TreeBidiMap.getParent(currentNode, index), index);
            currentNode = this.rootNode[index];
        }
        TreeBidiMap.makeBlack(currentNode, index);
    }

    private void swapPosition(Node<K, V> x, Node<K, V> y, int index) {
        boolean yWasLeftChild;
        Node xFormerParent = ((Node)x).getParent(index);
        Node xFormerLeftChild = ((Node)x).getLeft(index);
        Node xFormerRightChild = ((Node)x).getRight(index);
        Node yFormerParent = ((Node)y).getParent(index);
        Node yFormerLeftChild = ((Node)y).getLeft(index);
        Node yFormerRightChild = ((Node)y).getRight(index);
        boolean xWasLeftChild = ((Node)x).getParent(index) != null && x == ((Node)((Node)x).getParent(index)).getLeft(index);
        boolean bl = yWasLeftChild = ((Node)y).getParent(index) != null && y == ((Node)((Node)y).getParent(index)).getLeft(index);
        if (x == yFormerParent) {
            ((Node)x).setParent((Node)y, index);
            if (yWasLeftChild) {
                ((Node)y).setLeft((Node)x, index);
                ((Node)y).setRight(xFormerRightChild, index);
            } else {
                ((Node)y).setRight((Node)x, index);
                ((Node)y).setLeft(xFormerLeftChild, index);
            }
        } else {
            ((Node)x).setParent(yFormerParent, index);
            if (yFormerParent != null) {
                if (yWasLeftChild) {
                    yFormerParent.setLeft((Node)x, index);
                } else {
                    yFormerParent.setRight((Node)x, index);
                }
            }
            ((Node)y).setLeft(xFormerLeftChild, index);
            ((Node)y).setRight(xFormerRightChild, index);
        }
        if (y == xFormerParent) {
            ((Node)y).setParent((Node)x, index);
            if (xWasLeftChild) {
                ((Node)x).setLeft((Node)y, index);
                ((Node)x).setRight(yFormerRightChild, index);
            } else {
                ((Node)x).setRight((Node)y, index);
                ((Node)x).setLeft(yFormerLeftChild, index);
            }
        } else {
            ((Node)y).setParent(xFormerParent, index);
            if (xFormerParent != null) {
                if (xWasLeftChild) {
                    xFormerParent.setLeft((Node)y, index);
                } else {
                    xFormerParent.setRight((Node)y, index);
                }
            }
            ((Node)x).setLeft(yFormerLeftChild, index);
            ((Node)x).setRight(yFormerRightChild, index);
        }
        if (((Node)x).getLeft(index) != null) {
            ((Node)((Node)x).getLeft(index)).setParent((Node)x, index);
        }
        if (((Node)x).getRight(index) != null) {
            ((Node)((Node)x).getRight(index)).setParent((Node)x, index);
        }
        if (((Node)y).getLeft(index) != null) {
            ((Node)((Node)y).getLeft(index)).setParent((Node)y, index);
        }
        if (((Node)y).getRight(index) != null) {
            ((Node)((Node)y).getRight(index)).setParent((Node)y, index);
        }
        ((Node)x).swapColors((Node)y, index);
        if (this.rootNode[index] == x) {
            this.rootNode[index] = y;
        } else if (this.rootNode[index] == y) {
            this.rootNode[index] = x;
        }
    }

    private static void checkNonNullComparable(Object o) {
        if (o == null) {
            throw new NullPointerException("Cannot be null");
        }
        if (!(o instanceof Comparable)) {
            throw new ClassCastException("Must be Comparable");
        }
    }

    private static void checkKey(Object key) {
        TreeBidiMap.checkNonNullComparable(key);
    }

    private static void checkValue(Object value) {
        TreeBidiMap.checkNonNullComparable(value);
    }

    private static void checkKeyAndValue(Object key, Object value) {
        TreeBidiMap.checkKey(key);
        TreeBidiMap.checkValue(value);
    }

    private void modify() {
        ++this.modifications;
    }

    private void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private void shrink() {
        this.modify();
        --this.nodeCount;
    }

    private void insertValue(Node<K, V> newNode) throws IllegalArgumentException {
        block4: {
            Node node = this.rootNode[1];
            while (true) {
                int cmp;
                if ((cmp = TreeBidiMap.compare(((Node)newNode).getData(1), node.getData(1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + ((Node)newNode).getData(1) + "\") in this Map");
                }
                if (cmp < 0) {
                    if (node.getLeft(1) != null) {
                        node = node.getLeft(1);
                        continue;
                    }
                    node.setLeft((Node)newNode, 1);
                    ((Node)newNode).setParent(node, 1);
                    this.doRedBlackInsert(newNode, 1);
                    break block4;
                }
                if (node.getRight(1) == null) break;
                node = node.getRight(1);
            }
            node.setRight((Node)newNode, 1);
            ((Node)newNode).setParent(node, 1);
            this.doRedBlackInsert(newNode, 1);
        }
    }

    private boolean doEquals(Object obj, int type2) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (other.size() != this.size()) {
            return false;
        }
        if (this.nodeCount > 0) {
            try {
                ViewMapIterator it = new ViewMapIterator(this, type2);
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = it.getValue();
                    if (value.equals(other.get(key))) continue;
                    return false;
                }
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    private int doHashCode(int type2) {
        int total = 0;
        if (this.nodeCount > 0) {
            ViewMapIterator it = new ViewMapIterator(this, type2);
            while (it.hasNext()) {
                Object key = it.next();
                Object value = it.getValue();
                total += key.hashCode() ^ value.hashCode();
            }
        }
        return total;
    }

    private String doToString(int type2) {
        if (this.nodeCount == 0) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer(this.nodeCount * 32);
        buf.append('{');
        ViewMapIterator it = new ViewMapIterator(this, type2);
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Object key = it.next();
            Object value = it.getValue();
            buf.append((Object)(key == this ? "(this Map)" : key)).append('=').append((Object)(value == this ? "(this Map)" : value));
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Inverse<K extends Comparable, V extends Comparable>
    implements OrderedBidiMap<V, K> {
        private final TreeBidiMap<K, V> main;
        private Set keySet;
        private Set valuesSet;
        private Set entrySet;

        Inverse(TreeBidiMap<K, V> main) {
            this.main = main;
        }

        @Override
        public int size() {
            return this.main.size();
        }

        @Override
        public boolean isEmpty() {
            return this.main.isEmpty();
        }

        @Override
        public K get(Object key) {
            return (K)this.main.getKey((Comparable)key);
        }

        @Override
        public V getKey(Object value) {
            return (V)this.main.get(value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.main.containsValue(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.main.containsKey(value);
        }

        @Override
        public V firstKey() {
            if (((TreeBidiMap)this.main).nodeCount == 0) {
                throw new NoSuchElementException("Map is empty");
            }
            return (V)TreeBidiMap.leastNode(((TreeBidiMap)this.main).rootNode[1], 1).getValue();
        }

        @Override
        public V lastKey() {
            if (((TreeBidiMap)this.main).nodeCount == 0) {
                throw new NoSuchElementException("Map is empty");
            }
            return (V)TreeBidiMap.greatestNode(((TreeBidiMap)this.main).rootNode[1], 1).getValue();
        }

        @Override
        public V nextKey(V key) {
            TreeBidiMap.checkKey(key);
            Node node = ((TreeBidiMap)this.main).nextGreater(((TreeBidiMap)this.main).lookup(key, 1), 1);
            return (V)(node == null ? null : node.getValue());
        }

        @Override
        public V previousKey(V key) {
            TreeBidiMap.checkKey(key);
            Node node = ((TreeBidiMap)this.main).nextSmaller(((TreeBidiMap)this.main).lookup(key, 1), 1);
            return (V)(node == null ? null : node.getValue());
        }

        @Override
        public K put(V key, K value) {
            return (K)((TreeBidiMap)this.main).doPutByValue(value, key);
        }

        @Override
        public void putAll(Map<? extends V, ? extends K> map) {
            for (Map.Entry<V, K> entry : map.entrySet()) {
                this.put((V)((Comparable)entry.getKey()), (K)((Comparable)entry.getValue()));
            }
        }

        @Override
        public K remove(Object key) {
            return (K)this.main.removeValue((Comparable)key);
        }

        @Override
        public V removeValue(Object value) {
            return (V)this.main.remove(value);
        }

        @Override
        public void clear() {
            this.main.clear();
        }

        @Override
        public Set<V> keySet() {
            if (this.keySet == null) {
                this.keySet = new View(this.main, 1, 1);
            }
            return this.keySet;
        }

        @Override
        public Set<K> values() {
            if (this.valuesSet == null) {
                this.valuesSet = new View(this.main, 1, 0);
            }
            return this.valuesSet;
        }

        @Override
        public Set<Map.Entry<V, K>> entrySet() {
            if (this.entrySet == null) {
                return new EntryView(this.main, 1, 3);
            }
            return this.entrySet;
        }

        @Override
        public MapIterator<V, K> mapIterator() {
            if (this.isEmpty()) {
                return EmptyOrderedMapIterator.INSTANCE;
            }
            return new ViewMapIterator(this.main, 1);
        }

        @Override
        public OrderedMapIterator<V, K> orderedMapIterator() {
            if (this.isEmpty()) {
                return EmptyOrderedMapIterator.INSTANCE;
            }
            return new ViewMapIterator(this.main, 1);
        }

        @Override
        public BidiMap<K, V> inverseBidiMap() {
            return this.main;
        }

        @Override
        public OrderedBidiMap<K, V> inverseOrderedBidiMap() {
            return this.main;
        }

        @Override
        public boolean equals(Object obj) {
            return ((TreeBidiMap)this.main).doEquals(obj, 1);
        }

        @Override
        public int hashCode() {
            return ((TreeBidiMap)this.main).doHashCode(1);
        }

        public String toString() {
            return ((TreeBidiMap)this.main).doToString(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node<K extends Comparable, V extends Comparable>
    implements Map.Entry<K, V>,
    KeyValue<K, V> {
        private K key;
        private V value;
        private Node<K, V>[] leftNode;
        private Node<K, V>[] rightNode;
        private Node<K, V>[] parentNode;
        private boolean[] blackColor;
        private int hashcodeValue;
        private boolean calculatedHashCode;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
            this.leftNode = new Node[2];
            this.rightNode = new Node[2];
            this.parentNode = new Node[2];
            this.blackColor = new boolean[]{true, true};
            this.calculatedHashCode = false;
        }

        private Comparable getData(int index) {
            if (index == 0) {
                return this.key;
            }
            return this.value;
        }

        private void setLeft(Node<K, V> node, int index) {
            this.leftNode[index] = node;
        }

        private Node<K, V> getLeft(int index) {
            return this.leftNode[index];
        }

        private void setRight(Node<K, V> node, int index) {
            this.rightNode[index] = node;
        }

        private Node<K, V> getRight(int index) {
            return this.rightNode[index];
        }

        private void setParent(Node<K, V> node, int index) {
            this.parentNode[index] = node;
        }

        private Node<K, V> getParent(int index) {
            return this.parentNode[index];
        }

        private void swapColors(Node<K, V> node, int index) {
            int n = index;
            this.blackColor[n] = this.blackColor[n] ^ node.blackColor[index];
            int n2 = index;
            node.blackColor[n2] = node.blackColor[n2] ^ this.blackColor[index];
            int n3 = index;
            this.blackColor[n3] = this.blackColor[n3] ^ node.blackColor[index];
        }

        private boolean isBlack(int index) {
            return this.blackColor[index];
        }

        private boolean isRed(int index) {
            return !this.blackColor[index];
        }

        private void setBlack(int index) {
            this.blackColor[index] = true;
        }

        private void setRed(int index) {
            this.blackColor[index] = false;
        }

        private void copyColor(Node<K, V> node, int index) {
            this.blackColor[index] = node.blackColor[index];
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V ignored) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
        }

        @Override
        public int hashCode() {
            if (!this.calculatedHashCode) {
                this.hashcodeValue = this.key.hashCode() ^ this.value.hashCode();
                this.calculatedHashCode = true;
            }
            return this.hashcodeValue;
        }
    }

    static class EntryView
    extends View {
        private final int oppositeType;

        EntryView(TreeBidiMap main, int orderType, int dataType) {
            super(main, orderType, dataType);
            this.oppositeType = TreeBidiMap.oppositeIndex(orderType);
        }

        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value = entry.getValue();
            Node node = this.main.lookup((Comparable)entry.getKey(), this.orderType);
            return node != null && node.getData(this.oppositeType).equals(value);
        }

        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value = entry.getValue();
            Node node = this.main.lookup((Comparable)entry.getKey(), this.orderType);
            if (node != null && node.getData(this.oppositeType).equals(value)) {
                this.main.doRedBlackDelete(node);
                return true;
            }
            return false;
        }
    }

    static class ViewMapIterator
    extends ViewIterator
    implements OrderedMapIterator {
        private final int oppositeType;

        ViewMapIterator(TreeBidiMap main, int orderType) {
            super(main, orderType, orderType);
            this.oppositeType = TreeBidiMap.oppositeIndex(this.dataType);
        }

        public Object getKey() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException("Iterator getKey() can only be called after next() and before remove()");
            }
            return this.lastReturnedNode.getData(this.dataType);
        }

        public Object getValue() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException("Iterator getValue() can only be called after next() and before remove()");
            }
            return this.lastReturnedNode.getData(this.oppositeType);
        }

        public Object setValue(Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    static class ViewIterator
    implements OrderedIterator {
        protected final TreeBidiMap main;
        protected final int orderType;
        protected final int dataType;
        protected Node lastReturnedNode;
        protected Node nextNode;
        protected Node previousNode;
        private int expectedModifications;

        ViewIterator(TreeBidiMap main, int orderType, int dataType) {
            this.main = main;
            this.orderType = orderType;
            this.dataType = dataType;
            this.expectedModifications = main.modifications;
            this.nextNode = TreeBidiMap.leastNode(main.rootNode[orderType], orderType);
            this.lastReturnedNode = null;
            this.previousNode = null;
        }

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        public final Object next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (this.main.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedNode = this.nextNode;
            this.previousNode = this.nextNode;
            this.nextNode = this.main.nextGreater(this.nextNode, this.orderType);
            return this.doGetData();
        }

        public boolean hasPrevious() {
            return this.previousNode != null;
        }

        public Object previous() {
            if (this.previousNode == null) {
                throw new NoSuchElementException();
            }
            if (this.main.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.nextNode = this.lastReturnedNode;
            if (this.nextNode == null) {
                this.nextNode = this.main.nextGreater(this.previousNode, this.orderType);
            }
            this.lastReturnedNode = this.previousNode;
            this.previousNode = this.main.nextSmaller(this.previousNode, this.orderType);
            return this.doGetData();
        }

        protected Object doGetData() {
            switch (this.dataType) {
                case 0: {
                    return this.lastReturnedNode.getKey();
                }
                case 1: {
                    return this.lastReturnedNode.getValue();
                }
                case 2: {
                    return this.lastReturnedNode;
                }
                case 3: {
                    return new UnmodifiableMapEntry<Object, Object>(this.lastReturnedNode.getValue(), this.lastReturnedNode.getKey());
                }
            }
            return null;
        }

        public final void remove() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException();
            }
            if (this.main.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.main.doRedBlackDelete(this.lastReturnedNode);
            ++this.expectedModifications;
            this.lastReturnedNode = null;
            this.previousNode = this.nextNode == null ? TreeBidiMap.greatestNode(this.main.rootNode[this.orderType], this.orderType) : this.main.nextSmaller(this.nextNode, this.orderType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class View<K extends Comparable, V extends Comparable>
    extends AbstractSet {
        protected final TreeBidiMap main;
        protected final int orderType;
        protected final int dataType;

        View(TreeBidiMap main, int orderType, int dataType) {
            this.main = main;
            this.orderType = orderType;
            this.dataType = dataType;
        }

        @Override
        public Iterator iterator() {
            return new ViewIterator(this.main, this.orderType, this.dataType);
        }

        @Override
        public int size() {
            return this.main.size();
        }

        @Override
        public boolean contains(Object obj) {
            TreeBidiMap.checkNonNullComparable(obj);
            return this.main.lookup((Comparable)obj, this.dataType) != null;
        }

        @Override
        public boolean remove(Object obj) {
            if (this.dataType == 0) {
                return this.main.doRemoveByKey((Comparable)obj) != null;
            }
            return this.main.doRemoveByValue((Comparable)obj) != null;
        }

        @Override
        public void clear() {
            this.main.clear();
        }
    }
}

