/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15;

import org.apache.commons.collections15.ArrayStack;
import org.apache.commons.collections15.Buffer;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.buffer.BlockingBuffer;
import org.apache.commons.collections15.buffer.PredicatedBuffer;
import org.apache.commons.collections15.buffer.SynchronizedBuffer;
import org.apache.commons.collections15.buffer.TransformedBuffer;
import org.apache.commons.collections15.buffer.TypedBuffer;
import org.apache.commons.collections15.buffer.UnmodifiableBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferUtils {
    public static final Buffer EMPTY_BUFFER = UnmodifiableBuffer.decorate(new ArrayStack(1));

    public static <E> Buffer<E> synchronizedBuffer(Buffer<E> buffer) {
        return SynchronizedBuffer.decorate(buffer);
    }

    public static <E> Buffer<E> blockingBuffer(Buffer<E> buffer) {
        return BlockingBuffer.decorate(buffer);
    }

    public static <E> Buffer<E> unmodifiableBuffer(Buffer<E> buffer) {
        return UnmodifiableBuffer.decorate(buffer);
    }

    public static <E> Buffer<E> predicatedBuffer(Buffer<E> buffer, Predicate<E> predicate) {
        return PredicatedBuffer.decorate(buffer, predicate);
    }

    public static <E> Buffer<E> typedBuffer(Buffer<E> buffer, Class<E> type2) {
        return TypedBuffer.decorate(buffer, type2);
    }

    public static <I, O> Buffer<O> transformedBuffer(Buffer<I> buffer, Transformer<I, O> transformer) {
        return TransformedBuffer.decorate(buffer, transformer);
    }
}

