/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.util.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree {
    private String rootLabel;
    private String usePosLabel;
    private boolean terminal;
    private List<Tree> children = new ArrayList<Tree>();
    private Tree parent;

    public Tree() {
    }

    public Tree(String rootLabel) {
        this.rootLabel = rootLabel;
        this.usePosLabel = rootLabel;
        this.terminal = false;
    }

    public Tree(String rootLabel, char pos) {
        this.rootLabel = rootLabel;
        this.usePosLabel = rootLabel + "::" + pos;
        this.terminal = true;
    }

    public static Tree fromPennTree(String treeString) throws Exception {
        if (treeString == null || treeString.length() < 1) {
            throw new Exception("Parse error: empty (sub)tree");
        }
        Tree tree = null;
        if ((treeString = treeString.trim()).indexOf(40) == -1) {
            tree = new Tree(treeString);
        } else if (treeString.charAt(0) == '(' && treeString.charAt(treeString.length() - 1) == ')') {
            String content = treeString.substring(1, treeString.length() - 1);
            int firstPar = content.indexOf(40);
            if (firstPar == -1) {
                int firstBlank = content.indexOf(32);
                if (firstBlank == -1) {
                    tree = new Tree(content.trim());
                } else {
                    tree = new Tree(content.substring(0, firstBlank).trim());
                    tree.getChildren().add(new Tree(content.substring(firstBlank + 1).trim(), tree.getRootLabel().toLowerCase().charAt(0)));
                }
            } else {
                tree = new Tree(content.substring(0, firstPar).trim());
                content = content.substring(firstPar).trim();
                while (content.length() > 0) {
                    if (content.charAt(0) != '(') {
                        throw new Exception("Parse error for (sub)tree 1: ->" + content + "<- ->" + treeString + "<-");
                    }
                    int openPars = 1;
                    int index = 1;
                    while (openPars > 0) {
                        if (index >= content.length()) {
                            throw new Exception("Parse error for (sub)tree 2: " + treeString);
                        }
                        if (content.charAt(index) == ')') {
                            --openPars;
                        } else if (content.charAt(index) == '(') {
                            ++openPars;
                        }
                        ++index;
                    }
                    tree.getChildren().add(Tree.fromPennTree(content.substring(0, index).trim()));
                    content = content.substring(index).trim();
                }
            }
        } else {
            throw new Exception("Parse error for (sub)tree 3: " + treeString);
        }
        return tree;
    }

    public String toPennTree() {
        String treeString = "(" + this.rootLabel;
        if (this.children.size() == 1) {
            treeString = treeString + " ";
            treeString = this.children.get(0).getChildren().size() == 0 ? treeString + this.children.get(0).getRootLabel() : treeString + this.children.get(0).toPennTree();
        } else if (this.children.size() > 1) {
            treeString = treeString + " ";
            for (Tree child : this.children) {
                treeString = treeString + child.toPennTree();
            }
        }
        treeString = treeString + ")";
        return treeString;
    }

    public Tree cloneNode() {
        Tree clone = new Tree(this.rootLabel);
        clone.setUsePosLabel(this.usePosLabel);
        clone.setTerminal(this.terminal);
        return clone;
    }

    public void initializeParents() {
        this.initializeParent(null);
    }

    private void initializeParent(Tree parent) {
        this.parent = parent;
        for (Tree child : this.getChildren()) {
            child.initializeParent(this);
        }
    }

    public String toString() {
        return this.toPennTree();
    }

    public boolean equals(Tree tree) {
        if (!this.rootLabel.equals(tree.getRootLabel()) || !this.usePosLabel.equals(tree.getUsePosLabel())) {
            return false;
        }
        if (this.children.size() != tree.getChildren().size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i).equals(tree.getChildren().get(i))) continue;
            return false;
        }
        return true;
    }

    public String getRootLabel() {
        return this.rootLabel;
    }

    public void setRootLabel(String root) {
        this.rootLabel = root;
    }

    public List<Tree> getChildren() {
        return this.children;
    }

    public String getUsePosLabel() {
        return this.usePosLabel;
    }

    public void setUsePosLabel(String usePosLabel) {
        this.usePosLabel = usePosLabel;
    }

    public void setTerminal(boolean terminal2) {
        this.terminal = terminal2;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public void setChildren(Vector<Tree> children) {
        this.children = children;
    }

    public Tree getParent() {
        return this.parent;
    }

    public void setParent(Tree parent) {
        this.parent = parent;
    }
}

