/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.util.tree;

import java.util.Random;

public class RandomTreeGenerator {
    public String[] symbols = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public Random rand;

    public RandomTreeGenerator() {
        this(0);
    }

    public RandomTreeGenerator(int seed) {
        this.rand = new Random(seed);
    }

    public String generateRandomTree(int labels, int maxWidth, int nodes) {
        int maxSubtrees;
        if (labels > this.symbols.length || nodes < 2) {
            System.out.println("Error!");
            return "";
        }
        String tree = "(" + this.symbols[this.rand.nextInt(labels)] + " ";
        if ((maxSubtrees = Math.min(maxWidth, --nodes / 2)) == 0) {
            tree = tree + this.symbols[this.rand.nextInt(labels)].toLowerCase();
        } else {
            int subtrees = this.rand.nextInt(maxSubtrees) + 1;
            for (int i = subtrees - 1; i >= 0; --i) {
                int childNodes = i == 0 ? nodes : this.rand.nextInt(nodes - i * 2 - 1) + 2;
                tree = tree + this.generateRandomTree(labels, maxWidth, childNodes);
                nodes -= childNodes;
            }
        }
        tree = tree + ")";
        return tree;
    }

    public String[] getSymbols() {
        return this.symbols;
    }

    public void setSymbols(String[] symbols) {
        this.symbols = symbols;
    }
}

