/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.util.tree;

import it.uniroma2.util.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;

public class ArtificialTreeGenerator {
    public HashMap<String, HashMap<Double, String>> grammar = new HashMap();
    private Random rand;
    Random modification;

    public static void main(String[] args) {
        ArtificialTreeGenerator rtg = new ArtificialTreeGenerator(0);
        System.out.println(rtg.generateRandomTreeString());
    }

    public ArtificialTreeGenerator(int seed) {
        this.rand = new Random(seed);
        this.modification = new Random(seed);
        this.initialize();
    }

    private void initialize() {
        HashMap<Double, String> prodS = new HashMap<Double, String>();
        prodS.put(1.0, "AB");
        this.grammar.put("S", prodS);
        HashMap<Double, String> prodA = new HashMap<Double, String>();
        prodA.put(0.2, "AA");
        prodA.put(0.4, "CD");
        prodA.put(1.0, "e");
        this.grammar.put("A", prodA);
        HashMap<Double, String> prodB = new HashMap<Double, String>();
        prodB.put(0.2, "BB");
        prodB.put(0.4, "DC");
        prodB.put(1.0, "f");
        this.grammar.put("B", prodB);
        HashMap<Double, String> prodC = new HashMap<Double, String>();
        prodC.put(0.3333333333333333, "AB");
        prodC.put(0.6666666666666666, "A");
        prodC.put(1.0, "B");
        this.grammar.put("C", prodC);
        HashMap<Double, String> prodD = new HashMap<Double, String>();
        prodD.put(0.3333333333333333, "BA");
        prodD.put(0.6666666666666666, "A");
        prodD.put(1.0, "B");
        this.grammar.put("D", prodD);
    }

    public Tree generateRandomTree(int limit) throws Exception {
        String treet = this.generateRandomTreeString(limit);
        Tree x = Tree.fromPennTree(treet);
        return x;
    }

    public Tree generateRandomTree() throws Exception {
        String treet = this.generateRandomTreeString();
        Tree x = Tree.fromPennTree(treet);
        return x;
    }

    public String generateRandomTreeString(int limit) {
        if (limit < 4) {
            limit = 4;
        }
        String tree = this.generateRandomTreeString();
        while (tree.split(" ").length > limit) {
            tree = this.generateRandomTreeString();
        }
        return tree;
    }

    public String generateRandomTree(int middle, int range) {
        if (middle < 4) {
            middle = 4;
        }
        String tree = this.generateRandomTreeString();
        while (tree.split(" ").length > middle + range || tree.split(" ").length < middle - range) {
            tree = this.generateRandomTreeString();
        }
        return tree;
    }

    public String generateRandomTreeString() {
        return this.generateSubTree("S");
    }

    private String generateSubTree(String rootSymbol) {
        String result = rootSymbol + " ";
        String rhs = this.extractRule(rootSymbol);
        if (rhs.equals("e") || rhs.equals("f")) {
            result = result + rhs;
        } else {
            for (int i = 0; i < rhs.length(); ++i) {
                result = result + this.generateSubTree(rhs.substring(i, i + 1));
            }
        }
        return "(" + result + ")";
    }

    private String extractRule(String lhs) {
        int i;
        HashMap<Double, String> productions = this.grammar.get(lhs);
        ArrayList<Double> thresholds = new ArrayList<Double>();
        thresholds.addAll(productions.keySet());
        Collections.sort(thresholds);
        double t = this.rand.nextDouble();
        for (i = 0; i < thresholds.size() && !((Double)thresholds.get(i) >= t); ++i) {
        }
        return productions.get(thresholds.get(i));
    }

    public Tree randomlyModifyTree(String tree) throws Exception {
        Tree x = Tree.fromPennTree(tree);
        boolean modified = false;
        while (!modified) {
            modified = this.randomlyModifyTree(x);
        }
        return x;
    }

    public boolean randomlyModifyTree(Tree tree) throws Exception {
        boolean modified = false;
        if (this.modification.nextInt(100) < 10) {
            tree.setRootLabel("XX");
            modified = true;
        }
        for (Tree c : tree.getChildren()) {
            if (modified) continue;
            modified = this.randomlyModifyTree(c);
        }
        return modified;
    }
}

