/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.tk;

import edu.berkeley.compbio.jlibsvm.kernel.KernelFunction;
import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.tree.Tree;
import it.uniroma2.util.vector.SemanticVectorProvider;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothedTreeKernel
implements KernelFunction<Tree> {
    public static double lambda = 1.0;
    public static boolean lexicalized = false;
    private static int nodeCount = 0;
    private static HashMap<String, Double> deltaMatrix;
    private static HashMap<Tree, Integer> nodeIndices;
    private static SemanticVectorProvider ds;

    public static void initializeSemanticVectors(int vectorSize, File distributionalDictionary) throws Exception {
        ds = new SemanticVectorProvider(vectorSize, distributionalDictionary);
    }

    public static double value(Tree a, Tree b) throws Exception {
        deltaMatrix = new HashMap();
        nodeIndices = new HashMap();
        nodeCount = 0;
        double sum = 0.0;
        for (Tree aa : SmoothedTreeKernel.allNodes(a)) {
            for (Tree bb : SmoothedTreeKernel.allNodes(b)) {
                sum += SmoothedTreeKernel.delta(aa, bb);
            }
        }
        return sum;
    }

    private static double delta(Tree a, Tree b) throws Exception {
        double k = 0.0;
        if (!nodeIndices.containsKey(a)) {
            nodeIndices.put(a, nodeCount);
            ++nodeCount;
        }
        if (!nodeIndices.containsKey(b)) {
            nodeIndices.put(b, nodeCount);
            ++nodeCount;
        }
        if (deltaMatrix.containsKey(nodeIndices.get(a) + ":" + nodeIndices.get(b))) {
            return deltaMatrix.get(nodeIndices.get(a) + ":" + nodeIndices.get(b));
        }
        if (a.getChildren().size() == b.getChildren().size()) {
            if (a.getChildren().size() == 1 && a.getChildren().get(0).isTerminal() && b.getChildren().get(0).isTerminal()) {
                if (lexicalized) {
                    k = ArrayMath.cosine(ds.getVector(a.getRootLabel()), ds.getVector(b.getRootLabel()));
                }
            } else {
                k = ArrayMath.cosine(ds.getVector(a.getRootLabel()), ds.getVector(b.getRootLabel()));
                for (int i = 0; i < a.getChildren().size(); ++i) {
                    k *= 1.0 + lambda * SmoothedTreeKernel.delta(a.getChildren().get(i), b.getChildren().get(i));
                }
            }
        }
        deltaMatrix.put(nodeIndices.get(a) + ":" + nodeIndices.get(b), k);
        return k;
    }

    private static Vector<Tree> allNodes(Tree node) {
        Vector<Tree> all = new Vector<Tree>();
        all.add(node);
        for (Tree child : node.getChildren()) {
            all.addAll(SmoothedTreeKernel.allNodes(child));
        }
        return all;
    }

    @Override
    public double evaluate(Tree arg0, Tree arg1) {
        try {
            return SmoothedTreeKernel.value(arg0, arg1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    static {
        ds = null;
    }
}

