/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.svd.writer;

import it.uniroma2.svd.ExecSVD;
import it.uniroma2.svd.writer.BinaryMatrix;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseBinaryMatrix<T>
implements BinaryMatrix<T> {
    private RandomAccessFile _matrixFile;
    private ByteArrayInputStream b_arr;
    private DataInputStream b_in;
    private int n_row = -1;
    private int n_col = -1;
    private boolean sized = false;
    private Vector<Long> posMap;
    private int sizeType;
    private Class<T> tClass;
    private Method readMethod;
    private Method writeMethod;
    private Long currentElem = 0L;
    private int nonZeroElem = 0;
    private boolean bycol;
    private boolean fullLoad;

    public SparseBinaryMatrix(Class<T> c) {
        this.tClass = c;
        this.setType();
    }

    @Override
    public void openFile(String file, String mode) throws IOException {
        this.openFile(file, mode, false);
    }

    public void openFile(String file, String mode, boolean deleteExist) throws IOException {
        if (mode.equals("r")) {
            deleteExist = false;
        }
        this.openFile(file, mode, true, false, deleteExist);
    }

    public void openFile(String file, String mode, boolean _bycol, boolean _fullLoad, boolean deleteExist) throws IOException {
        this.bycol = _bycol;
        this.fullLoad = _fullLoad;
        File _file = new File(file);
        boolean exist = _file.exists();
        if (exist && deleteExist) {
            _file.delete();
            exist = false;
        }
        this._matrixFile = new RandomAccessFile(file, mode);
        this.posMap = new Vector();
        if (!exist) {
            this._matrixFile.setLength(12L);
            this._matrixFile.seek(12L);
        } else {
            this._matrixFile.seek(0L);
            this.n_row = this._matrixFile.readInt();
            this.n_col = this._matrixFile.readInt();
            this.readPosition();
        }
        if (this.fullLoad) {
            int size = (int)this._matrixFile.length();
            this._matrixFile.seek(0L);
            byte[] buf = new byte[size];
            System.out.println(">>> Reading complete file; size: " + size);
            int read = this._matrixFile.read(buf, 0, size);
            if (read != size) {
                System.out.println(">>>> ERROR during load sparse matrix read: " + read + "  size: " + size + " buf: " + buf.length);
                for (int i = 0; i < 10; ++i) {
                    System.out.print(buf[i]);
                }
                System.out.print("\n");
                System.exit(1);
            }
            this.b_arr = new ByteArrayInputStream(buf);
            this.b_in = new DataInputStream(this.b_arr);
        }
    }

    private void readPosition() throws IOException {
        this._matrixFile.seek(12L);
        int items = this.bycol ? this.n_col : this.n_row;
        for (int i = 0; i < items; ++i) {
            long pos = this._matrixFile.getFilePointer();
            int it = this._matrixFile.readInt();
            this._matrixFile.skipBytes(it * (4 + this.sizeType));
            this.posMap.add(pos);
        }
    }

    @Override
    public void closeFile() throws IOException {
        this._matrixFile.close();
    }

    public void writeInt(Integer i) throws IOException {
        this._matrixFile.writeInt(i);
    }

    public void writeFloat(Float i) throws IOException {
        this._matrixFile.writeFloat(i.floatValue());
    }

    public void writeDouble(Double i) throws IOException {
        this._matrixFile.writeDouble(i);
    }

    public Integer readInt() throws IOException {
        if (this.fullLoad) {
            return this.b_in.readInt();
        }
        return this._matrixFile.readInt();
    }

    public Float readFloat() throws IOException {
        if (this.fullLoad) {
            return Float.valueOf(this.b_in.readFloat());
        }
        return Float.valueOf(this._matrixFile.readFloat());
    }

    public Double readDouble() throws IOException {
        if (this.fullLoad) {
            return this.b_in.readDouble();
        }
        return this._matrixFile.readDouble();
    }

    public void setSize(int row, int col) {
        this.n_col = col;
        this.n_row = row;
        this.sized = true;
    }

    public void setCol(int col) {
        this.n_col = col;
    }

    public void setType() {
        try {
            if (this.tClass.equals(Integer.class)) {
                this.sizeType = 4;
                this.readMethod = this.getClass().getMethod("readInt", new Class[0]);
                this.writeMethod = this.getClass().getMethod("writeInt", Integer.class);
            } else if (this.tClass.equals(Float.class)) {
                this.readMethod = this.getClass().getMethod("readFloat", new Class[0]);
                this.writeMethod = this.getClass().getMethod("writeFloat", Float.class);
                this.sizeType = 4;
            } else if (this.tClass.equals(Double.class)) {
                this.readMethod = this.getClass().getMethod("readDouble", new Class[0]);
                this.writeMethod = this.getClass().getMethod("writeDouble", Double.class);
                this.sizeType = 8;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public void readSize() throws IOException {
        this._matrixFile.seek(0L);
        this.n_row = this._matrixFile.readInt();
        this.n_col = this._matrixFile.readInt();
    }

    public void writeSize() throws IOException {
        this._matrixFile.seek(0L);
        this._matrixFile.writeInt(this.n_row);
        this._matrixFile.writeInt(this.n_col);
        this._matrixFile.writeInt(this.nonZeroElem);
    }

    @Override
    public T getElement(int row, int col) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.bycol) {
            int read;
            Long pos = this.posMap.elementAt(col);
            int i = 0;
            if (this.fullLoad) {
                if (this.currentElem > pos) {
                    this.b_in.reset();
                    this.b_in.skip(pos);
                } else {
                    this.b_in.skip(pos - this.currentElem);
                }
                this.currentElem = pos;
                int limit = this.b_in.readInt();
                this.currentElem = this.currentElem + 4L;
                while ((read = this.b_in.readInt()) < row && i++ < limit) {
                    this.currentElem = this.currentElem + 4L;
                    this.b_in.skipBytes(this.sizeType);
                    this.currentElem = this.currentElem + (long)this.sizeType;
                }
                this.currentElem = this.currentElem + 4L;
            } else {
                this._matrixFile.seek(pos);
                int limit = this._matrixFile.readInt();
                try {
                    while ((read = this._matrixFile.readInt()) < row && i++ < limit) {
                        this._matrixFile.skipBytes(this.sizeType);
                    }
                }
                catch (EOFException e) {
                    return null;
                }
            }
            if (read == row) {
                this.currentElem = this.currentElem + (long)this.sizeType;
                return (T)this.readMethod.invoke((Object)this, null);
            }
        } else {
            int read;
            Long pos = this.posMap.elementAt(row);
            int i = 0;
            if (this.fullLoad) {
                if (this.currentElem > pos) {
                    this.b_in.reset();
                    this.b_in.skip(pos);
                } else {
                    this.b_in.skip(pos - this.currentElem);
                }
                int limit = this.b_in.readInt();
                this.currentElem = this.currentElem + 4L;
                while ((read = this.b_in.readInt()) < col && i++ < limit) {
                    this.currentElem = this.currentElem + 4L;
                    this.b_in.skipBytes(this.sizeType);
                    this.currentElem = this.currentElem + (long)this.sizeType;
                }
            } else {
                this._matrixFile.seek(pos);
                int limit = this._matrixFile.readInt();
                while ((read = this._matrixFile.readInt()) < col && i++ < limit) {
                    this._matrixFile.skipBytes(this.sizeType);
                }
            }
            if (read == col) {
                this.currentElem = this.currentElem + (long)this.sizeType;
                return (T)this.readMethod.invoke((Object)this, null);
            }
        }
        return null;
    }

    @Override
    public T[] getFullRow(int row) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        return null;
    }

    @Override
    public T[] getFullCol(int col) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return null;
    }

    @Override
    public TreeMap<Integer, T> getSparseRow(int row) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        TreeMap<Integer, Object> ret = new TreeMap<Integer, Object>();
        if (this.bycol) {
            for (int i = 0; i < this.n_col; ++i) {
                T elem = this.getElement(row, i);
                if (elem == null) continue;
                ret.put(i, elem);
            }
        } else {
            Long pos = this.posMap.elementAt(row);
            if (this.fullLoad) {
                if (this.currentElem > pos) {
                    this.b_in.reset();
                    this.b_in.skip(pos);
                } else {
                    this.b_in.skip(pos - this.currentElem);
                }
                int count = this.b_in.readInt();
                this.currentElem = this.currentElem + 4L;
                for (int i = 0; i < count; ++i) {
                    int col = this.b_in.readInt();
                    this.currentElem = this.currentElem + 4L;
                    Object val = this.readMethod.invoke((Object)this, null);
                    this.currentElem = this.currentElem + (long)this.sizeType;
                    ret.put(col, val);
                }
            } else {
                this._matrixFile.seek(pos);
                int count = this._matrixFile.readInt();
                for (int i = 0; i < count; ++i) {
                    int col = this._matrixFile.readInt();
                    Object val = this.readMethod.invoke((Object)this, null);
                    ret.put(col, val);
                }
            }
        }
        return ret;
    }

    public TreeMap<Integer, T> getSparseColTranspose(int col, String pathMatrix) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        try {
            SparseBinaryMatrix<Float> sbmOldT = new SparseBinaryMatrix<Float>(Float.class);
            sbmOldT.openFile(pathMatrix + "_T", "r");
            TreeMap<Integer, Float> vet = sbmOldT.getSparseCol(col);
            sbmOldT.closeFile();
            return vet;
        }
        catch (Exception e) {
            ExecSVD execSVD = new ExecSVD();
            execSVD.transposeMatrix(pathMatrix);
            return this.getSparseColTranspose(col, pathMatrix);
        }
    }

    @Override
    public TreeMap<Integer, T> getSparseCol(int col) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        TreeMap<Integer, Object> ret = new TreeMap<Integer, Object>();
        if (this.bycol) {
            Long pos = this.posMap.elementAt(col);
            if (this.fullLoad) {
                if (this.currentElem > pos) {
                    this.b_in.reset();
                    this.b_in.skip(pos);
                } else {
                    this.b_in.skip(pos - this.currentElem);
                }
                int count = this.b_in.readInt();
                this.currentElem = this.currentElem + 4L;
                for (int i = 0; i < count; ++i) {
                    int row = this.b_in.readInt();
                    this.currentElem = this.currentElem + 4L;
                    Object val = this.readMethod.invoke((Object)this, null);
                    this.currentElem = this.currentElem + (long)this.sizeType;
                    ret.put(row, val);
                }
            } else {
                this._matrixFile.seek(pos);
                int count = this._matrixFile.readInt();
                for (int i = 0; i < count; ++i) {
                    int row = this._matrixFile.readInt();
                    Object val = this.readMethod.invoke((Object)this, null);
                    ret.put(row, val);
                }
            }
        } else {
            for (int i = 0; i < this.n_row; ++i) {
                T elem = this.getElement(i, col);
                if (elem == null) continue;
                ret.put(i, elem);
            }
        }
        return ret;
    }

    public void setSparse(SortedMap<Integer, T> items) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.posMap.add(this._matrixFile.getFilePointer());
        this.nonZeroElem += items.size();
        this._matrixFile.writeInt(items.size());
        for (Integer key : items.keySet()) {
            this._matrixFile.writeInt(key);
            this.writeMethod.invoke((Object)this, items.get(key));
        }
        Long l = this.currentElem;
        Long l2 = this.currentElem = Long.valueOf(this.currentElem + 1L);
    }

    @Override
    public int getCols() {
        return this.n_col;
    }

    @Override
    public int getRows() {
        return this.n_row;
    }

    public void printAll() throws IOException {
        this._matrixFile.seek(0L);
        int rows = this._matrixFile.readInt();
        int cols = this._matrixFile.readInt();
        if (this.bycol) {
            int tmp = rows;
            rows = cols;
            cols = tmp;
        }
        int items = this._matrixFile.readInt();
        System.out.println(cols + " " + rows + " " + items);
        int countrow = 0;
        while (countrow++ < rows) {
            int rowitems = this._matrixFile.readInt();
            int countitem = 0;
            System.out.println(rowitems);
            while (countitem++ < rowitems) {
                System.out.println(this._matrixFile.readInt() + " " + this._matrixFile.readFloat());
            }
        }
    }

    public void printOctave(String path) throws IOException, IllegalAccessException, InvocationTargetException {
        this._matrixFile.seek(0L);
        int rows = this._matrixFile.readInt();
        int cols = this._matrixFile.readInt();
        if (this.bycol) {
            int tmp = rows;
            rows = cols;
            cols = tmp;
        }
        int items = this._matrixFile.readInt();
        FileWriter matrixOut = new FileWriter(path + ".mtx");
        matrixOut.write("%%MatrixMarket matrix coordinate real general \n");
        matrixOut.write(rows + " " + cols + " " + items + "\n");
        int countrow = 0;
        while (countrow++ < rows) {
            int rowitems = this._matrixFile.readInt();
            int countitem = 0;
            while (countitem++ < rowitems) {
                matrixOut.write(countrow + " " + (this._matrixFile.readInt() + 1) + " " + this._matrixFile.readFloat() + "\n");
            }
        }
        matrixOut.close();
    }

    public Double sum(Double a, Double b) {
        Double res = a + b;
        return res;
    }

    public Float sum(Float a, Float b) {
        Float res = Float.valueOf(a.floatValue() + b.floatValue());
        return res;
    }

    public Integer sum(Integer a, Integer b) {
        Integer res = a + b;
        return res;
    }

    public Double mult(Double a, Double b) {
        return a * b;
    }

    public Float mult(Float a, Float b) {
        return Float.valueOf(a.floatValue() * b.floatValue());
    }

    public Integer mult(Integer a, Integer b) {
        return a * b;
    }

    public Double div(Double a, Double b) {
        return a / b;
    }

    public Float div(Float a, Float b) {
        return Float.valueOf(a.floatValue() / b.floatValue());
    }

    public Integer div(Integer a, Integer b) {
        return a / b;
    }

    public static void main(String[] args) {
        SparseBinaryMatrix<Float> mat = new SparseBinaryMatrix<Float>(Float.class);
        if (args.length != 1) {
            System.out.println("Usage: " + SparseBinaryMatrix.class + " <matrix>");
            System.exit(1);
        }
    }

    @Override
    public void setElement(int row, int col, T value) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
    }

    @Override
    public void setFullCol(int col, T[] colelem) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
    }

    @Override
    public void setFullRow(int row, T[] values) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
    }

    @Override
    public void setSparseCol(int col, Map<Integer, T> values) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
    }

    @Override
    public void setSparseRow(int row, Map<Integer, T> values) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        SUM,
        DIV,
        MULT;

    }
}

