/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.svd;

import it.uniroma2.svd.StreamGobbler;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class ExecSVD {
    private int _lsadim;
    private String _outpath;
    private String _inputfile;
    private String _svdExec;
    private boolean binary_input = true;
    private boolean binary_output = true;

    public ExecSVD() {
        this._svdExec = "lib/lsa/linux_x86_64/svd";
    }

    public ExecSVD(int lsadim, String _outBaseDir, String smtx) {
        this._lsadim = lsadim;
        this._inputfile = _outBaseDir + File.separator + smtx;
        this._outpath = _outBaseDir + File.separator + lsadim + File.separator;
        this._svdExec = "lib/lsa/linux_x86_64/svd";
    }

    public void ExecSVDFromPath(int lsadim, String _outBaseDir, String pathSmtx) {
        this._lsadim = lsadim;
        this._inputfile = pathSmtx;
        this._outpath = _outBaseDir + File.separator + lsadim + File.separator;
        this._svdExec = "lib/lsa/linux_x86_64/svd";
    }

    public ExecSVD(int lsadim, File _outBaseDir, File smtx, boolean _binary_input, boolean _binary_output) {
        this.binary_input = _binary_input;
        this.binary_output = _binary_output;
        this._lsadim = lsadim;
        this._inputfile = smtx.getAbsolutePath();
        this._outpath = _outBaseDir.getAbsolutePath() + File.separator + lsadim + File.separator;
        this._svdExec = "lib/lsa/linux_x86_64/svd";
    }

    public void transposeMatrix(String inputFile) {
        ExecSVD.CmdExec(this._svdExec + " -r sb -w sb -t " + " -c " + inputFile + " " + inputFile + "_T");
    }

    public void runSVD() {
        File _outDir = new File(this._outpath);
        if (_outDir.exists() && !_outDir.delete()) {
            for (File file : _outDir.listFiles()) {
                file.delete();
            }
        }
        _outDir.mkdirs();
        ExecSVD.CmdExec(this._svdExec + " -r " + (this.binary_input ? "db" : "dt") + " -w " + (this.binary_output ? "db" : "dt") + " -d " + this._lsadim + " -o " + this._outpath + "svd " + this._inputfile);
        File svdS = new File(this._outpath + "svd-S");
        if (!svdS.exists()) {
            ExecSVD.CmdExec(this._svdExec + " -r " + (this.binary_input ? "db" : "dt") + " -w " + (this.binary_output ? "db" : "dt") + " -d " + this._lsadim + " -o " + this._outpath + "svd " + this._inputfile + "_T");
        }
    }

    public static void CmdExec(String cmdline) {
        try {
            String[] commandLine = new String[]{"/bin/sh", "-c", cmdline};
            System.out.println("Execute /bin/sh -c " + cmdline);
            Process p = Runtime.getRuntime().exec(commandLine);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String input_line = reader.readLine();
            while (input_line != null) {
                System.out.println("SVD OUTPUT : " + input_line);
                input_line = reader.readLine();
            }
            int exit = p.waitFor();
            System.out.println("Exit value: " + exit);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), "ERROR");
            errorGobbler.start();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }
}

