/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.exp.tools;

public class AvgVarCalculator {
    private int samplesNum;
    private double sampleSum;
    private double sampleSquareSum;
    private double lastSample;

    public AvgVarCalculator() {
        this.reset();
    }

    public void reset() {
        this.samplesNum = 0;
        this.sampleSum = 0.0;
        this.sampleSquareSum = 0.0;
        this.lastSample = 0.0;
    }

    public void addSample(double sample) {
        ++this.samplesNum;
        this.sampleSum += sample;
        this.sampleSquareSum += sample * sample;
        this.lastSample = sample;
    }

    public double getAvg() {
        return this.sampleSum / (double)this.samplesNum;
    }

    public double getVar() {
        return this.sampleSquareSum / (double)this.samplesNum - this.getAvg() * this.getAvg();
    }

    public double getLastSample() {
        return this.lastSample;
    }

    public String getFormattedResult() {
        return this.getFormattedResult(4);
    }

    public String getFormattedResult(int precision) {
        return String.format("%." + precision + "f\t%." + precision + "f", this.getAvg(), this.getVar());
    }
}

