/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.exp.dtk;

import it.uniroma2.exp.AbstractExperiment;
import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.vector.RandomVectorGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;

public class SpaceTester
extends AbstractExperiment {
    private ArrayList<double[]>[] vectors;
    private double[] epsilons = new double[0];
    private boolean unlimited = false;

    public void setEpsilons(double[] epsilons) {
        Arrays.sort(epsilons);
        this.epsilons = epsilons;
    }

    public void setUnlimited(boolean unlimited) {
        this.unlimited = unlimited;
    }

    public void printCount() {
        for (int i = 0; i < this.epsilons.length; ++i) {
            this.out.println("Found (at least) " + this.vectors[i].size() + " vectors with dot product < " + this.epsilons[i]);
        }
    }

    protected void runExperiment() throws Exception {
        RandomVectorGenerator rvg = new RandomVectorGenerator(this.vectorSize, this.randomOffset);
        if (this.vectors == null) {
            this.vectors = new ArrayList[this.epsilons.length];
            for (int i = 0; i < this.epsilons.length; ++i) {
                this.vectors[i] = new ArrayList();
            }
        } else {
            for (ArrayList<double[]> vector : this.vectors) {
                vector.clear();
            }
        }
        int c = 0;
        int i = 0;
        while (c < this.vectorSize || this.unlimited) {
            if (i++ % 1000 == 0) {
                this.out.print(".");
            }
            double[] newVector = rvg.generateRandomVector();
            boolean atLeastOneOk = false;
            for (int k = this.epsilons.length - 1; k >= 0; --k) {
                boolean ok = true;
                for (double[] oldVector : this.vectors[k]) {
                    if (!(ArrayMath.dot(oldVector, newVector) >= this.epsilons[k])) continue;
                    ok = false;
                    break;
                }
                if (!ok) break;
                atLeastOneOk = true;
                this.vectors[k].add(newVector);
            }
            if (atLeastOneOk) {
                c = 0;
                continue;
            }
            ++c;
        }
        this.out.println();
        this.printCount();
    }

    public static void main(String[] args) {
        final SpaceTester st = new SpaceTester();
        if (args.length > 0 && args[0].equalsIgnoreCase("t")) {
            st.setUnlimited(true);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    st.printCount();
                }
            });
        }
        try {
            st.setOutputStream(new PrintStream(new File("space_tester.dat")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(0);
        }
        st.setVectorSizeArray(new int[]{4096, 8192});
        st.setEpsilons(new double[]{0.01, 0.05});
        st.runAll();
    }
}

