/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.dtk.op.convolution;

import it.uniroma2.dtk.op.convolution.CircularConvolution;
import it.uniroma2.util.vector.VectorComposer;
import java.util.Arrays;

public class ReverseCircularConvolution
extends CircularConvolution {
    public double[] op(double[] x, double[] y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (this.fft2 != null) {
            return this.reverseConvolutionFFT2(x, y);
        }
        if (this.fft != null) {
            return this.reverseConvolutionFFT(x, y);
        }
        return this.reverseConvolutionBasic(x, y);
    }

    public double[] reverseConvolutionBasic(double[] firstVector, double[] secondVector) {
        int size = firstVector.length;
        double[] result = new double[size];
        Arrays.fill(result, 0.0);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int n = i;
                result[n] = result[n] + firstVector[j] * secondVector[i - j < 0 ? size - 1 - (i - j + size) : size - 1 - (i - j)];
            }
        }
        return result;
    }

    public double[] reverseConvolutionFFT(double[] firstVector, double[] secondVector) {
        return this.circularConvolutionFFT(VectorComposer.reverse(firstVector), VectorComposer.reverse(secondVector));
    }

    public double[] reverseConvolutionFFT2(double[] firstVector, double[] secondVector) {
        return this.circularConvolutionFFT2(VectorComposer.reverse(firstVector), VectorComposer.reverse(secondVector));
    }
}

