/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.dtk.op.convolution;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import it.uniroma2.dtk.op.TransformAndCompose;
import it.uniroma2.util.math.Complex;
import it.uniroma2.util.math.FFT;
import it.uniroma2.util.vector.VectorProvider;
import java.util.Arrays;

public class CircularConvolution
extends TransformAndCompose {
    protected FFT fft = null;
    protected int spaceGrade = 0;
    protected DoubleFFT_1D fft2 = null;

    public double[] op(double[] x, double[] y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (this.fft2 != null) {
            return this.circularConvolutionFFT2(x, y);
        }
        if (this.fft != null) {
            return this.circularConvolutionFFT(x, y);
        }
        return this.circularConvolutionBasic(x, y);
    }

    protected double[] circularConvolutionBasic(double[] firstVector, double[] secondVector) {
        int size = firstVector.length;
        double[] result = new double[size];
        Arrays.fill(result, 0.0);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int n = i;
                result[n] = result[n] + firstVector[j] * secondVector[i - j < 0 ? i - j + size : i - j];
            }
        }
        return result;
    }

    protected double[] circularConvolutionFFT(double[] firstVector, double[] secondVector) {
        return Complex.extract(this.fft.real_cconvolve(Complex.generate(firstVector), Complex.generate(secondVector), this.spaceGrade));
    }

    protected double[] circularConvolutionFFT2(double[] a, double[] b) {
        int N = a.length;
        double[] first = new double[2 * N];
        for (int i = 0; i < N; ++i) {
            first[i] = a[i];
        }
        double[] second = new double[2 * N];
        for (int i = 0; i < N; ++i) {
            second[i] = b[i];
        }
        this.fft2.realForwardFull(first);
        this.fft2.realForwardFull(second);
        double[] c = new double[2 * N];
        for (int i = 0; i < N; ++i) {
            c[2 * i] = first[2 * i] * second[2 * i] - first[2 * i + 1] * second[2 * i + 1];
            c[2 * i + 1] = first[2 * i] * second[2 * i + 1] + first[2 * i + 1] * second[2 * i];
        }
        this.fft2.complexInverse(c, true);
        double[] out = new double[N];
        for (int i = 0; i < N; ++i) {
            out[i] = c[2 * i];
        }
        return out;
    }

    public void initialize(VectorProvider vp) throws Exception {
        super.initialize(vp);
        int exp = this.log2(vp.getVectorSize());
        if (exp < 0) {
            System.out.println("Using the slow circular convolution as vector size is not power of 2");
        } else {
            if (System.getProperties().containsKey("fft1")) {
                System.out.println("Fast CircularConvolution in use");
                this.fft = new FFT();
                this.fft.initialize(exp);
            } else {
                System.out.println("Fast CircularConvolution (with threads) in use");
                this.fft2 = new DoubleFFT_1D(vp.getVectorSize());
            }
            this.spaceGrade = exp;
        }
    }

    protected int log2(int arg) {
        int exp = 0;
        double pow;
        while ((pow = Math.pow(2.0, exp)) != (double)arg) {
            if (pow > (double)arg) {
                return -1;
            }
            ++exp;
        }
        return exp;
    }
}

