/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.dtk.op;

import it.uniroma2.dtk.op.IdealOperation;
import it.uniroma2.util.vector.VectorComposer;
import it.uniroma2.util.vector.VectorProvider;
import java.util.Arrays;
import java.util.Random;

public abstract class TransformAndCompose
implements IdealOperation {
    protected int[] permutation1;
    protected int[] permutation2;

    public abstract double[] op(double[] var1, double[] var2);

    public void initialize(VectorProvider vp) throws Exception {
        int size = vp.getVectorSize();
        this.permutation1 = this.generatePermutation(size, 0, null);
        this.permutation2 = this.generatePermutation(size, 1, this.permutation1);
    }

    protected int[] generatePermutation(int size, int seed, int[] anotherPermutation) {
        Random rand = new Random(seed);
        int[] permutation = this.generateRandomPermutation(size, rand);
        while (!this.testPermutation(permutation, anotherPermutation)) {
            System.out.println("Discarding permutation!");
            permutation = this.generateRandomPermutation(size, rand);
        }
        return permutation;
    }

    protected int[] generateRandomPermutation(int size, Random rand) {
        int[] permutation = new int[size];
        double[] toOrder = new double[size];
        for (int i = 0; i < size; ++i) {
            toOrder[i] = rand.nextGaussian();
        }
        double[] ordered = Arrays.copyOf(toOrder, size);
        Arrays.sort(ordered);
        block1: for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (toOrder[i] != ordered[j]) continue;
                permutation[i] = toOrder[i] < 0.0 ? -j : j;
                continue block1;
            }
        }
        return permutation;
    }

    protected boolean testPermutation(int[] permutation, int[] anotherPermutation) {
        double[] basic = new double[permutation.length];
        for (int i = 0; i < basic.length; ++i) {
            basic[i] = i;
        }
        double[] shuffled = Arrays.copyOf(basic, basic.length);
        for (int i = 0; i < basic.length; ++i) {
            if (Arrays.equals(shuffled = VectorComposer.shuffle(shuffled, permutation), basic)) {
                return false;
            }
            if (anotherPermutation == null) continue;
            if (Arrays.equals(shuffled, VectorComposer.shuffle(basic, anotherPermutation))) {
                return false;
            }
            if (!Arrays.equals(basic, VectorComposer.shuffle(shuffled, anotherPermutation))) continue;
            return false;
        }
        return true;
    }
}

