/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.dtk.dt.subpath;

import it.uniroma2.dtk.common.Spectrum;
import it.uniroma2.dtk.dt.DT;
import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.math.MatrixUtils;
import it.uniroma2.util.tree.Tree;
import it.uniroma2.util.vector.RandomVectorGenerator;
import it.uniroma2.util.vector.VectorComposer;
import it.uniroma2.util.vector.VectorProvider;

public abstract class SubPathAbstractDT
implements DT {
    protected VectorProvider vectorProvider;
    protected int vectorSize;
    protected boolean usePos;
    protected double lambdaSq = 1.0;

    public SubPathAbstractDT(int randomOffset, int vectorsSize, boolean usePos, double lambda) throws Exception {
        this.vectorProvider = new RandomVectorGenerator(vectorsSize, randomOffset);
        this.vectorSize = vectorsSize;
        this.usePos = usePos;
        this.lambdaSq = Math.sqrt(lambda);
    }

    public SubPathAbstractDT(int randomOffset, int vectorsSize, boolean usePos) throws Exception {
        this(randomOffset, vectorsSize, usePos, 1.0);
    }

    public SubPathAbstractDT(int randomOffset, int vectorsSize, double lambda) throws Exception {
        this(randomOffset, vectorsSize, false, lambda);
    }

    public abstract double[] op(double[] var1, double[] var2) throws Exception;

    public int getVectorSize() {
        return this.vectorSize;
    }

    public VectorProvider getVectorProvider() {
        return this.vectorProvider;
    }

    public double[] dt(Tree x) {
        Spectrum result = new Spectrum();
        result.setVector(MatrixUtils.uniformVector(this.vectorSize, 0.0));
        try {
            this.sRecursive(x, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.getVector();
    }

    protected double[] sRecursive(Tree node, Spectrum sum) throws Exception {
        double[] result = MatrixUtils.uniformVector(this.vectorSize, 0.0);
        if (!node.isTerminal()) {
            for (int i = 0; i < node.getChildren().size(); ++i) {
                Tree child = node.getChildren().get(i);
                result = VectorComposer.sum(result, this.sRecursive(child, sum));
            }
            result = this.op(this.getLabelVector(node), result);
        }
        result = ArrayMath.scalardot(this.lambdaSq, VectorComposer.sum(this.getLabelVector(node), result));
        sum.setVector(VectorComposer.sum(sum.getVector(), result));
        return result;
    }

    public double[] dtf(Tree x) {
        double[] result = MatrixUtils.uniformVector(this.vectorSize, 0.0);
        try {
            if (x.getChildren().size() != 1) {
                throw new Exception("Tree fragments for the Subpath Kernel MUST be paths: " + x.toPennTree());
            }
            result = ArrayMath.scalardot(1.0 / this.lambdaSq, this.op(this.getLabelVector(x), this.dtf(x.getChildren().get(0))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public double[] getLabelVector(Tree node) throws Exception {
        if (this.usePos) {
            return this.vectorProvider.getVector(node.getUsePosLabel());
        }
        return this.vectorProvider.getVector(node.getRootLabel());
    }

    public double getLambda() {
        return this.lambdaSq * this.lambdaSq;
    }

    public void setLambda(double lambda) {
        this.lambdaSq = Math.sqrt(lambda);
    }

    public boolean isUsePos() {
        return this.usePos;
    }

    public void setUsePos(boolean usePos) {
        this.usePos = usePos;
    }
}

