/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.dtk.dt.route;

import it.uniroma2.dtk.common.Spectrum;
import it.uniroma2.dtk.dt.DT;
import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.math.MatrixUtils;
import it.uniroma2.util.tree.Tree;
import it.uniroma2.util.vector.RandomVectorGenerator;
import it.uniroma2.util.vector.VectorComposer;
import it.uniroma2.util.vector.VectorProvider;
import java.util.HashMap;

public abstract class RouteAbstractDT
implements DT {
    protected VectorProvider vectorProvider;
    protected int vectorSize;
    protected boolean useProductions;
    protected double lambdaSq = 1.0;
    protected HashMap<Integer, double[]> edgeVectors = new HashMap();
    protected String edgeMarker = Character.toString('\u0006');

    public RouteAbstractDT(int randomOffset, int vectorsSize, boolean useProductions, double lambda) throws Exception {
        this.vectorProvider = new RandomVectorGenerator(vectorsSize, randomOffset);
        this.vectorSize = vectorsSize;
        this.useProductions = useProductions;
        this.lambdaSq = Math.sqrt(lambda);
    }

    public RouteAbstractDT(int randomOffset, int vectorsSize, boolean useProductions) throws Exception {
        this(randomOffset, vectorsSize, useProductions, 1.0);
    }

    public RouteAbstractDT(int randomOffset, int vectorsSize, double lambda) throws Exception {
        this(randomOffset, vectorsSize, false, lambda);
    }

    public abstract double[] op(double[] var1, double[] var2) throws Exception;

    public int getVectorSize() {
        return this.vectorSize;
    }

    public VectorProvider getVectorProvider() {
        return this.vectorProvider;
    }

    public double[] dt(Tree x) {
        Spectrum result = new Spectrum();
        result.setVector(MatrixUtils.uniformVector(this.vectorSize, 0.0));
        try {
            this.sRecursive(x, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.getVector();
    }

    protected double[] sRecursive(Tree node, Spectrum sum) throws Exception {
        double[] result = MatrixUtils.uniformVector(this.vectorSize, 0.0);
        if (!node.isTerminal()) {
            for (int i = 0; i < node.getChildren().size(); ++i) {
                Tree child = node.getChildren().get(i);
                result = VectorComposer.sum(result, this.op(this.getEdgeVector(i), this.sRecursive(child, sum)));
            }
            result = ArrayMath.scalardot(this.lambdaSq, result);
        }
        result = this.useProductions ? VectorComposer.sum(this.getProductionVector(node), result) : VectorComposer.sum(this.getLabelVector(node), result);
        sum.setVector(VectorComposer.sum(sum.getVector(), result));
        return result;
    }

    public double[] dtf(Tree x) {
        System.err.println("Not available (positional information is missing)");
        return null;
    }

    public double[] getLabelVector(Tree node) throws Exception {
        return this.vectorProvider.getVector(node.getRootLabel());
    }

    public double[] getProductionVector(Tree node) throws Exception {
        double[] result = this.vectorProvider.getVector(node.getRootLabel());
        for (Tree child : node.getChildren()) {
            result = this.op(result, this.vectorProvider.getVector(child.getRootLabel()));
        }
        return result;
    }

    public double[] getEdgeVector(int index) throws Exception {
        if (this.edgeVectors == null) {
            this.edgeVectors = new HashMap();
        }
        if (this.edgeVectors.containsKey(index)) {
            return this.edgeVectors.get(index);
        }
        double[] vector = this.vectorProvider.getVector(this.edgeMarker + index);
        this.edgeVectors.put(index, vector);
        return vector;
    }

    public double getLambda() {
        return this.lambdaSq * this.lambdaSq;
    }

    public void setLambda(double lambda) {
        this.lambdaSq = Math.sqrt(lambda);
    }

    public boolean isUseProductions() {
        return this.useProductions;
    }

    public void setUseProductions(boolean useProductions) {
        this.useProductions = useProductions;
    }
}

