/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.dtk.dt;

import it.uniroma2.dtk.common.Spectrum;
import it.uniroma2.dtk.dt.DT;
import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.math.MatrixUtils;
import it.uniroma2.util.tree.Tree;
import it.uniroma2.util.vector.RandomVectorGenerator;
import it.uniroma2.util.vector.VectorComposer;
import it.uniroma2.util.vector.VectorProvider;

public abstract class DefaultAbstractDT
implements DT {
    protected VectorProvider vectorProvider;
    protected int vectorSize;
    protected boolean usePos;
    protected boolean lexicalized;
    protected double lambdaSq = 1.0;

    public DefaultAbstractDT(int randomOffset, int vectorsSize, boolean usePos, boolean lexicalized, double lambda) throws Exception {
        this.vectorProvider = new RandomVectorGenerator(vectorsSize, randomOffset);
        this.vectorSize = vectorsSize;
        this.usePos = usePos;
        this.lexicalized = lexicalized;
        this.lambdaSq = Math.sqrt(lambda);
    }

    public DefaultAbstractDT(int randomOffset, int vectorsSize, boolean usePos, boolean lexicalized) throws Exception {
        this(randomOffset, vectorsSize, usePos, lexicalized, 1.0);
    }

    public DefaultAbstractDT(int randomOffset, int vectorsSize, double lambda) throws Exception {
        this(randomOffset, vectorsSize, false, true, lambda);
    }

    public abstract double[] op(double[] var1, double[] var2) throws Exception;

    public int getVectorSize() {
        return this.vectorSize;
    }

    public VectorProvider getVectorProvider() {
        return this.vectorProvider;
    }

    public double[] dt(Tree x) {
        Spectrum result = new Spectrum();
        result.setVector(MatrixUtils.uniformVector(this.vectorSize, 0.0));
        try {
            this.sRecursive(x, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.getVector();
    }

    protected double[] sRecursive(Tree node, Spectrum sum) throws Exception {
        double[] result = MatrixUtils.uniformVector(this.vectorSize, 0.0);
        if (!node.isTerminal()) {
            boolean preterminal = true;
            for (int i = 0; i < node.getChildren().size(); ++i) {
                Tree child = node.getChildren().get(i);
                double[] childVector = this.getLabelVector(child);
                if (!child.isTerminal()) {
                    childVector = VectorComposer.sum(this.getLabelVector(child), ArrayMath.scalardot(this.lambdaSq, this.sRecursive(child, sum)));
                    preterminal = false;
                }
                result = i == 0 ? childVector : this.op(result, childVector);
            }
            if (!preterminal || this.lexicalized) {
                result = this.op(this.getLabelVector(node), result);
                sum.setVector(VectorComposer.sum(sum.getVector(), result));
            } else {
                result = MatrixUtils.uniformVector(this.vectorSize, 0.0);
            }
        }
        return result;
    }

    public double[] dtf(Tree x) {
        double[] result = MatrixUtils.uniformVector(this.vectorSize, 0.0);
        try {
            if (x.getChildren().size() == 0) {
                result = ArrayMath.scalardot(1.0 / this.lambdaSq, this.getLabelVector(x));
            } else {
                result = ArrayMath.scalardot(this.lambdaSq, this.dtf(x.getChildren().get(0)));
                for (int i = 1; i < x.getChildren().size(); ++i) {
                    result = this.op(result, ArrayMath.scalardot(this.lambdaSq, this.dtf(x.getChildren().get(i))));
                }
                result = this.op(this.getLabelVector(x), result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public double[] getLabelVector(Tree node) throws Exception {
        if (this.usePos) {
            return this.vectorProvider.getVector(node.getUsePosLabel());
        }
        return this.vectorProvider.getVector(node.getRootLabel());
    }

    public double getLambda() {
        return this.lambdaSq * this.lambdaSq;
    }

    public void setLambda(double lambda) {
        this.lambdaSq = Math.sqrt(lambda);
    }

    public boolean isUsePos() {
        return this.usePos;
    }

    public void setUsePos(boolean usePos) {
        this.usePos = usePos;
    }

    public boolean isLexicalized() {
        return this.lexicalized;
    }

    public void setLexicalized(boolean lexicalized) {
        this.lexicalized = lexicalized;
    }
}

