/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.mcmc;

import com.davidsoergel.runutils.Property;
import com.davidsoergel.runutils.PropertyConsumer;
import com.davidsoergel.stats.DoubleTimecourse;
import edu.berkeley.compbio.ml.mcmc.DataCollector;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

@PropertyConsumer
public class TextFileDataCollector
implements DataCollector {
    private static final Logger logger = Logger.getLogger(TextFileDataCollector.class);
    @Property(inherited=true)
    public String outputDirectoryName;
    @Property(defaultvalue="trajectory")
    public String trajectoryFilename;
    @Property(defaultvalue="ensemble")
    public String ensembleFilename;
    private final HashMap<String, DoubleTimecourse> timecourses = new HashMap();
    private int lastStep;
    private FileWriter trajectoryWriter;
    private FileWriter ensembleWriter;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Formatter formatter = new Formatter(sb, Locale.US);
        for (DoubleTimecourse t : this.timecourses.values()) {
            formatter.format("%1$20s = %2$10s, %3$10s\n", t.name(), t.last(), t.runningaverage());
        }
        return sb.toString();
    }

    public void close() {
        try {
            this.trajectoryWriter.flush();
            this.trajectoryWriter.close();
            this.ensembleWriter.flush();
            this.ensembleWriter.close();
            this.trajectoryWriter = null;
            this.ensembleWriter = null;
        }
        catch (IOException e) {
            logger.error("Error", e);
        }
    }

    public void init() {
        File outputDirectory = new File(this.outputDirectoryName);
        logger.debug("Writing outputs to " + this.outputDirectoryName);
        logger.debug("Found directory: " + outputDirectory);
        try {
            String trajectoryFilename = outputDirectory.getCanonicalPath() + File.separator + "trajectory";
            this.ensembleFilename = outputDirectory.getCanonicalPath() + File.separator + "sampleEnsemble";
            this.trajectoryWriter = new FileWriter(trajectoryFilename);
            this.ensembleWriter = new FileWriter(this.ensembleFilename);
        }
        catch (IOException e) {
            logger.error("Error", e);
        }
    }

    public DataCollector newSubCollector(String name) {
        throw new NotImplementedException();
    }

    public void setTimecourseValue(String name, double val) {
        DoubleTimecourse t = this.timecourses.get(name);
        t.set(val);
    }

    public void writeSample(String s) {
        try {
            this.ensembleWriter.write(s);
            this.ensembleWriter.flush();
        }
        catch (IOException e) {
            logger.error("Error", e);
        }
    }

    public int getStep() {
        return this.lastStep;
    }

    public void setStep(int lastStep) {
        this.lastStep = lastStep;
    }

    public void writeLatestTrajectoryValues() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getStep()).append(", ");
        for (DoubleTimecourse t : this.timecourses.values()) {
            sb.append(t.last());
            sb.append(", ");
            sb.append(t.runningaverage());
            sb.append(", ");
        }
        sb.append("\n");
        try {
            this.trajectoryWriter.write(sb.toString());
            this.trajectoryWriter.flush();
        }
        catch (IOException e) {
            logger.error("Error", e);
        }
    }
}

