/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.distancemeasure;

import com.davidsoergel.stats.DissimilarityMeasure;
import edu.berkeley.compbio.ml.cluster.ClusterableDoubleArray;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EuclideanDistance
implements DissimilarityMeasure<ClusterableDoubleArray> {
    private static final Logger logger = Logger.getLogger(EuclideanDistance.class);
    private static final EuclideanDistance _instance = new EuclideanDistance();

    public static EuclideanDistance getInstance() {
        return _instance;
    }

    @Override
    public double distanceFromTo(ClusterableDoubleArray a, ClusterableDoubleArray b) {
        double sum = 0.0;
        int l = a.length();
        for (int i = 0; i < l; ++i) {
            double x = a.get(i);
            double y = b.get(i);
            sum += (x - y) * (x - y);
        }
        return Math.sqrt(sum);
    }
}

