/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.stats;

import com.davidsoergel.trees.DepthFirstTreeIterator;
import com.davidsoergel.trees.LengthWeightHierarchyNode;
import com.davidsoergel.trees.TreeException;
import edu.berkeley.compbio.ml.cluster.ClusterList;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.ClusteringStats;
import edu.berkeley.compbio.ml.cluster.SimpleClusterList;
import edu.berkeley.compbio.ml.cluster.hierarchical.HierarchicalCentroidCluster;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalClusteringStats {
    final HierarchicalCentroidCluster theClustering;

    public HierarchicalClusteringStats(HierarchicalCentroidCluster theClustering) {
        this.theClustering = theClustering;
    }

    public Map<Double, ClusteringStats> statsByLevel(Collection<Double> thresholds) throws TreeException {
        HashMap<Double, ClusteringStats> result = new HashMap<Double, ClusteringStats>();
        Map clusterSets = HierarchicalClusteringStats.selectOTUs(this.theClustering, thresholds);
        for (Map.Entry entry : clusterSets.entrySet()) {
            Double threshold = entry.getKey();
            ClusterList clusters = entry.getValue();
            ClusteringStats stats = new ClusteringStats(clusters);
            result.put(threshold, stats);
        }
        return result;
    }

    private static <T extends Clusterable<T>> Map<Double, ClusterList<T>> selectOTUs(HierarchicalCentroidCluster<T> tree, Collection<Double> thresholds) throws TreeException {
        DepthFirstTreeIterator it = tree.depthFirstIterator();
        HashMap<Double, ClusterList<T>> results = new HashMap<Double, ClusterList<T>>();
        int i = 0;
        for (Double threshold : thresholds) {
            HashSet<HierarchicalCentroidCluster> result = new HashSet<HierarchicalCentroidCluster>();
            double halfThreshold = threshold / 2.0;
            while (it.hasNext()) {
                HierarchicalCentroidCluster node = (HierarchicalCentroidCluster)it.next();
                Collection children = node.getChildren();
                if (!children.isEmpty() && !(((LengthWeightHierarchyNode)children.iterator().next()).getLength() < halfThreshold)) continue;
                result.add(node);
                it.skipAllDescendants(node);
            }
            results.put(threshold, new SimpleClusterList(result));
            ++i;
        }
        return results;
    }
}

