/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.kohonen;

import com.davidsoergel.dsutils.collections.ConcurrentHashWeightedSet;
import com.davidsoergel.dsutils.collections.ImmutableHashWeightedSet;
import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.CentroidCluster;
import edu.berkeley.compbio.ml.cluster.kohonen.DiffusableLabelClusteringMethod;
import edu.berkeley.compbio.ml.cluster.kohonen.LabelDiffuser;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeighborhoodCollectingLabelDiffuser<T extends AdditiveClusterable<T>, C extends CentroidCluster<T>>
implements LabelDiffuser<T, C> {
    private static final Logger logger = Logger.getLogger(NeighborhoodCollectingLabelDiffuser.class);
    final int requiredLabels;

    public NeighborhoodCollectingLabelDiffuser(int requiredLabels) {
        this.requiredLabels = requiredLabels;
    }

    @Override
    public void propagateLabels(DiffusableLabelClusteringMethod<T, C> theMap) {
        int i = 0;
        for (CentroidCluster cell : theMap.getClusters()) {
            ConcurrentHashWeightedSet<String> weightedLabels = new ConcurrentHashWeightedSet<String>();
            Iterator<Set<CentroidCluster>> shells = theMap.getNeighborhoodShellIterator(cell);
            while (weightedLabels.getItemCount() < this.requiredLabels) {
                for (CentroidCluster shellMember : shells.next()) {
                    weightedLabels.addAll(shellMember.getImmutableWeightedLabels());
                }
            }
            cell.setDerivedLabelProbabilities(new ImmutableHashWeightedSet<String>(weightedLabels));
            if (i % 1000 == 0) {
                logger.debug("Relabeled " + i + " nodes.");
            }
            ++i;
        }
    }
}

