/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.kohonen;

import com.davidsoergel.stats.DissimilarityMeasure;
import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.ClusterMove;
import edu.berkeley.compbio.ml.cluster.NoGoodClusterException;
import edu.berkeley.compbio.ml.cluster.kohonen.CoarseGridSearchStrategy;
import edu.berkeley.compbio.ml.cluster.kohonen.KohonenSOM2D;
import edu.berkeley.compbio.ml.cluster.kohonen.KohonenSOM2DSearchStrategy;
import edu.berkeley.compbio.ml.cluster.kohonen.KohonenSOMCell;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NearCurrentPositionSearchStrategy<T extends AdditiveClusterable<T>>
extends KohonenSOM2DSearchStrategy<T> {
    private static final Logger logger = Logger.getLogger(NearCurrentPositionSearchStrategy.class);
    final KohonenSOM2DSearchStrategy<T> fallbackStrategy = new CoarseGridSearchStrategy();

    @Override
    public ClusterMove<T, KohonenSOMCell<T>> bestClusterMove(T p) throws NoGoodClusterException {
        ClusterMove result = new ClusterMove();
        String id = p.getId();
        result.oldCluster = this.som.getAssignment(id);
        if (result.oldCluster == null) {
            return this.fallbackStrategy.bestClusterMove(p);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Choosing best cluster for " + p + " (previous = " + result.oldCluster + ")");
        }
        Iterator<KohonenSOM2D.WeightedCell> i = this.som.getWeightedMask((int)this.getSearchRadius()).iterator((KohonenSOMCell)result.oldCluster);
        while (i.hasNext()) {
            KohonenSOMCell c = i.next().theCell;
            double d = this.measure.distanceFromTo(p, c.getCentroid());
            if (d < result.bestDistance) {
                result.secondBestDistance = result.bestDistance;
                result.bestDistance = d;
                result.bestCluster = c;
                continue;
            }
            if (!(d < result.secondBestDistance)) continue;
            result.secondBestDistance = d;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Chose " + result.bestCluster);
        }
        if (result.bestCluster == null) {
            throw new NoGoodClusterException("No cluster found for " + p + ": " + result);
        }
        return result;
    }

    public double getSearchRadius() {
        return 8.0;
    }

    @Override
    public void setDistanceMeasure(DissimilarityMeasure<T> dissimilarityMeasure) {
        super.setDistanceMeasure(dissimilarityMeasure);
        this.fallbackStrategy.setDistanceMeasure(dissimilarityMeasure);
    }

    @Override
    public void setSOM(KohonenSOM2D<T> som) {
        super.setSOM(som);
        this.fallbackStrategy.setSOM(som);
    }
}

