/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.kohonen;

import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.ClusterMove;
import edu.berkeley.compbio.ml.cluster.kohonen.KohonenSOM2DSearchStrategy;
import edu.berkeley.compbio.ml.cluster.kohonen.KohonenSOMCell;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BruteForceSearchStrategy<T extends AdditiveClusterable<T>>
extends KohonenSOM2DSearchStrategy<T> {
    private static final Logger logger = Logger.getLogger(BruteForceSearchStrategy.class);

    @Override
    public ClusterMove<T, KohonenSOMCell<T>> bestClusterMove(T p) {
        ClusterMove result = new ClusterMove();
        String id = p.getId();
        result.oldCluster = this.som.getAssignment(id);
        if (logger.isTraceEnabled()) {
            logger.trace("Choosing best cluster for " + p + " (previous = " + result.oldCluster + ")");
        }
        for (KohonenSOMCell c : this.som.getClusters()) {
            double d = this.measure.distanceFromTo(p, c.getCentroid());
            if (d < result.bestDistance) {
                result.secondBestDistance = result.bestDistance;
                result.bestDistance = d;
                result.bestCluster = c;
                continue;
            }
            if (!(d < result.secondBestDistance)) continue;
            result.secondBestDistance = d;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Chose " + result.bestCluster);
        }
        if (result.bestCluster == null) {
            logger.warn("Can't classify: " + p);
            assert (false);
        }
        return result;
    }
}

