/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.hierarchical;

import com.davidsoergel.dsutils.collections.DSCollectionUtils;
import com.davidsoergel.dsutils.collections.IndexedSymmetric2dBiMapWithDefault;
import com.davidsoergel.stats.DissimilarityMeasure;
import com.davidsoergel.trees.BasicPhylogenyNode;
import com.davidsoergel.trees.PhylogenyNode;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.hierarchical.Agglomerator;
import edu.berkeley.compbio.ml.cluster.hierarchical.BatchAgglomerativeClusteringMethod;
import edu.berkeley.compbio.ml.cluster.hierarchical.HierarchicalCentroidCluster;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomOrderedBatchAgglomerativeClusteringMethod<T extends Clusterable<T>>
extends BatchAgglomerativeClusteringMethod<T> {
    private static final Logger logger = Logger.getLogger(RandomOrderedBatchAgglomerativeClusteringMethod.class);

    public RandomOrderedBatchAgglomerativeClusteringMethod(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> tProhibitionModel, Set<String> testLabels, Agglomerator agg) {
        super(dm, potentialTrainingBins, predictLabelSets, tProhibitionModel, testLabels, agg);
    }

    public RandomOrderedBatchAgglomerativeClusteringMethod(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> tProhibitionModel, Set<String> testLabels, ArrayList<HierarchicalCentroidCluster<T>> theClusters, Map<String, HierarchicalCentroidCluster<T>> assignments, int n, Agglomerator agg, IndexedSymmetric2dBiMapWithDefault<HierarchicalCentroidCluster<T>, Float> theActiveNodeDistanceMatrix) {
        super(dm, potentialTrainingBins, predictLabelSets, tProhibitionModel, testLabels, theClusters, assignments, n, agg, theActiveNodeDistanceMatrix);
    }

    @Override
    public synchronized void train() {
        this.setN(this.theActiveNodeDistanceMatrix.numKeys());
        HashSet parentlessNodes = new HashSet(this.theActiveNodeDistanceMatrix.getKeys());
        while (parentlessNodes.size() > 1) {
            HierarchicalCentroidCluster node = (HierarchicalCentroidCluster)DSCollectionUtils.chooseRandom(parentlessNodes);
            BasicPhylogenyNode bestCluster = null;
            double bestDistance = Double.MAX_VALUE;
            for (HierarchicalCentroidCluster testCluster : this.theActiveNodeDistanceMatrix.getKeys()) {
                double dist;
                if (testCluster.equals(node) || !((dist = (double)((Float)this.theActiveNodeDistanceMatrix.get(node, testCluster)).floatValue()) < bestDistance)) continue;
                bestDistance = dist;
                bestCluster = testCluster;
            }
            List ancestors = bestCluster.getAncestorPath(false);
            if (!ancestors.isEmpty()) {
                HashSet ancestorChildren = new HashSet();
                for (PhylogenyNode phylogenyNode : ancestors) {
                    ancestorChildren.addAll(phylogenyNode.getChildren());
                    this.theActiveNodeDistanceMatrix.remove((HierarchicalCentroidCluster)phylogenyNode);
                }
                assert (ancestorChildren.contains(bestCluster));
                ancestorChildren.removeAll(ancestors);
                this.theClusters.removeAll(ancestors);
                parentlessNodes.removeAll(ancestors);
                for (PhylogenyNode<Object> phylogenyNode : ancestorChildren) {
                    phylogenyNode.setLength(null);
                    phylogenyNode.setParent(null);
                    parentlessNodes.add((HierarchicalCentroidCluster)phylogenyNode);
                }
            }
            HierarchicalCentroidCluster composite = this.agglomerator.joinNodes(this.nextId.getAndIncrement(), node, bestCluster, this.theActiveNodeDistanceMatrix);
            parentlessNodes.remove(node);
            parentlessNodes.remove(bestCluster);
            parentlessNodes.add(composite);
            this.addCluster(composite);
            this.theRoot = composite;
        }
        this.normalizeClusterLabelProbabilities();
    }
}

