/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.hierarchical;

import com.davidsoergel.conja.Function;
import com.davidsoergel.conja.Parallel;
import com.davidsoergel.dsutils.collections.IndexedSymmetric2dBiMapWithDefault;
import com.davidsoergel.stats.DissimilarityMeasure;
import edu.berkeley.compbio.ml.cluster.CentroidCluster;
import edu.berkeley.compbio.ml.cluster.ClusterMove;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.ClusterableIterator;
import edu.berkeley.compbio.ml.cluster.NoGoodClusterException;
import edu.berkeley.compbio.ml.cluster.PointClusterFilter;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.hierarchical.Agglomerator;
import edu.berkeley.compbio.ml.cluster.hierarchical.BatchAgglomerativeClusteringMethod;
import edu.berkeley.compbio.ml.cluster.hierarchical.HierarchicalCentroidCluster;
import edu.berkeley.compbio.ml.cluster.hierarchical.OnlineHierarchicalClusteringMethod;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlineAgglomerativeClustering<T extends Clusterable<T>>
extends OnlineHierarchicalClusteringMethod<T> {
    private static final Logger logger = Logger.getLogger(OnlineAgglomerativeClustering.class);
    public static final Float LONG_DISTANCE = Float.valueOf(Float.MAX_VALUE);
    protected final IndexedSymmetric2dBiMapWithDefault<HierarchicalCentroidCluster<T>, Float> theActiveNodeDistanceMatrix = new IndexedSymmetric2dBiMapWithDefault(LONG_DISTANCE);
    private HierarchicalCentroidCluster<T> theRoot;
    private final Map<T, HierarchicalCentroidCluster<T>> sampleToLeafClusterMap = new HashMap<T, HierarchicalCentroidCluster<T>>();
    private final AtomicInteger idCount = new AtomicInteger(0);
    HierarchicalCentroidCluster<T> saveNode;
    double threshold;
    Agglomerator<T> agglomerator;

    public OnlineAgglomerativeClustering(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels, Double threshold, Agglomerator agg) {
        super(dm, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels);
        this.threshold = threshold;
        this.agglomerator = agg;
    }

    @Override
    public ClusterMove<T, HierarchicalCentroidCluster<T>> bestClusterMove(T p) throws NoGoodClusterException {
        ClusterMove result = new ClusterMove();
        result.bestDistance = Double.POSITIVE_INFINITY;
        HierarchicalCentroidCluster<T> c = this.sampleToLeafClusterMap.get(p);
        if (c != null) {
            result.bestCluster = c;
            result.bestDistance = 0.0;
            return result;
        }
        PointClusterFilter<T> clusterFilter = this.prohibitionModel == null ? null : this.prohibitionModel.getFilter(p);
        for (HierarchicalCentroidCluster theCluster : this.getClusters()) {
            double distance;
            if (clusterFilter != null && clusterFilter.isProhibited(theCluster) || !((distance = this.measure.distanceFromTo(p, theCluster.getCentroid())) < result.bestDistance)) continue;
            result.bestCluster = theCluster;
            result.bestDistance = distance;
        }
        if (result.bestCluster == null) {
            throw new NoGoodClusterException("No cluster found for point: " + p);
        }
        return result;
    }

    @Override
    protected synchronized void trainWithKnownTrainingLabels(ClusterableIterator<T> samples) {
        Clusterable s1 = (Clusterable)samples.next();
        Clusterable s2 = (Clusterable)samples.next();
        HierarchicalCentroidCluster<Clusterable> s1c = new HierarchicalCentroidCluster<Clusterable>(this.idCount.getAndIncrement(), s1);
        HierarchicalCentroidCluster<Clusterable> s2c = new HierarchicalCentroidCluster<Clusterable>(this.idCount.getAndIncrement(), s2);
        float d = (float)this.measure.distanceFromTo(((CentroidCluster)s1c.getPayload()).getCentroid(), ((CentroidCluster)s2c.getPayload()).getCentroid());
        this.theActiveNodeDistanceMatrix.put(s1c, s2c, Float.valueOf(d));
        Parallel.forEach(samples, new Function<T, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void apply(T sample) {
                HierarchicalCentroidCluster c = new HierarchicalCentroidCluster(OnlineAgglomerativeClustering.this.idCount.getAndIncrement(), sample);
                c.doneLabelling();
                Collection activeClusters = OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.getKeys();
                int ahc = c.hashCode();
                HashMap distancesToC = new HashMap(OnlineAgglomerativeClustering.this.getClusters().size());
                for (HierarchicalCentroidCluster b : activeClusters) {
                    if (ahc > b.hashCode() || c.equals(b)) continue;
                    float d = (float)OnlineAgglomerativeClustering.this.measure.distanceFromTo(((CentroidCluster)c.getPayload()).getCentroid(), ((CentroidCluster)b.getPayload()).getCentroid());
                    distancesToC.put(b, Float.valueOf(d));
                }
                IndexedSymmetric2dBiMapWithDefault indexedSymmetric2dBiMapWithDefault = OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix;
                synchronized (indexedSymmetric2dBiMapWithDefault) {
                    Collection activeKeys = OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.getKeys();
                    if (activeKeys.size() > 0) {
                        HashSet remainingActiveKeys = new HashSet(activeKeys);
                        distancesToC.keySet().retainAll(remainingActiveKeys);
                        for (Map.Entry entry : distancesToC.entrySet()) {
                            HierarchicalCentroidCluster b = (HierarchicalCentroidCluster)entry.getKey();
                            float d = ((Float)entry.getValue()).floatValue();
                            OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.put(c, b, Float.valueOf(d));
                            remainingActiveKeys.remove(b);
                        }
                        for (HierarchicalCentroidCluster b : remainingActiveKeys) {
                            float d = (float)OnlineAgglomerativeClustering.this.measure.distanceFromTo(((CentroidCluster)c.getPayload()).getCentroid(), ((CentroidCluster)b.getPayload()).getCentroid());
                            OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.put(c, b, Float.valueOf(d));
                        }
                        while ((double)OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.getSmallestValue().floatValue() <= OnlineAgglomerativeClustering.this.threshold) {
                            HierarchicalCentroidCluster b;
                            HierarchicalCentroidCluster a = OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.getKey1WithSmallestValue();
                            b = OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.getKey2WithSmallestValue();
                            assert (OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.getKeys().contains(a));
                            assert (OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.getKeys().contains(b));
                            assert (!OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.getKeys().contains(a));
                            assert (!OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.getKeys().contains(b));
                            HierarchicalCentroidCluster composite = OnlineAgglomerativeClustering.this.agglomerator.joinNodes(OnlineAgglomerativeClustering.this.idCount.getAndIncrement(), a, b, OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix);
                            OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.remove(a);
                            OnlineAgglomerativeClustering.this.theActiveNodeDistanceMatrix.remove(b);
                            OnlineAgglomerativeClustering.this.addCluster(composite);
                            OnlineAgglomerativeClustering.this.theRoot = composite;
                        }
                    }
                }
                return null;
            }
        });
        BatchAgglomerativeClusteringMethod<T> batchClustering = new BatchAgglomerativeClusteringMethod<T>(this.measure, this.potentialTrainingBins, this.predictLabelSets, this.prohibitionModel, this.testLabels, this.theClusters, this.assignments, this.n, this.agglomerator, this.theActiveNodeDistanceMatrix);
        batchClustering.train();
        this.theRoot = batchClustering.getTree();
        this.normalizeClusterLabelProbabilities();
    }

    @Override
    public HierarchicalCentroidCluster<T> getTree() {
        return this.theRoot;
    }
}

