/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.hierarchical;

import com.davidsoergel.stats.DissimilarityMeasure;
import edu.berkeley.compbio.ml.cluster.AbstractClusteringMethod;
import edu.berkeley.compbio.ml.cluster.CentroidClusteringMethod;
import edu.berkeley.compbio.ml.cluster.CentroidClusteringUtils;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.ClusterableIterator;
import edu.berkeley.compbio.ml.cluster.DistanceMatrixBatchClusteringMethod;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.SupervisedClusteringMethod;
import edu.berkeley.compbio.ml.cluster.hierarchical.HierarchicalCentroidCluster;
import edu.berkeley.compbio.ml.cluster.hierarchical.HierarchicalClusteringMethod;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchHierarchicalClusteringMethod<T extends Clusterable<T>>
extends AbstractClusteringMethod<T, HierarchicalCentroidCluster<T>>
implements DistanceMatrixBatchClusteringMethod<T>,
SupervisedClusteringMethod<T>,
CentroidClusteringMethod<T>,
HierarchicalClusteringMethod<T> {
    protected BatchHierarchicalClusteringMethod(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels) {
        super(dm, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels);
    }

    public BatchHierarchicalClusteringMethod(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> tProhibitionModel, Set<String> testLabels, ArrayList<HierarchicalCentroidCluster<T>> theClusters, Map<String, HierarchicalCentroidCluster<T>> assignments, int n) {
        super(dm, potentialTrainingBins, predictLabelSets, tProhibitionModel, testLabels, theClusters, assignments, n);
    }

    @Override
    public String shortClusteringStats() {
        return CentroidClusteringUtils.shortClusteringStats(this.getClusters(), this.measure);
    }

    @Override
    public void computeClusterStdDevs(ClusterableIterator<T> theDataPointProvider) {
        CentroidClusteringUtils.computeClusterStdDevs(this.getClusters(), this.measure, this.getAssignments(), theDataPointProvider);
    }

    @Override
    public String clusteringStats() {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        CentroidClusteringUtils.writeClusteringStatsToStream(this.getClusters(), this.measure, b);
        return b.toString();
    }

    @Override
    public void writeClusteringStatsToStream(OutputStream outf) {
        CentroidClusteringUtils.writeClusteringStatsToStream(this.getClusters(), this.measure, outf);
    }
}

