/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.hierarchical;

import com.davidsoergel.dsutils.collections.Symmetric2dBiMap;
import com.davidsoergel.trees.PhylogenyNode;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.hierarchical.HierarchicalCentroidCluster;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Agglomerator<T extends Clusterable<T>> {
    protected abstract void addCompositeVsNodeToDistanceMatrix(HierarchicalCentroidCluster<T> var1, HierarchicalCentroidCluster<T> var2, HierarchicalCentroidCluster<T> var3, HierarchicalCentroidCluster<T> var4, Symmetric2dBiMap<HierarchicalCentroidCluster<T>, Float> var5);

    private void addCompositeToDistanceMatrix(HierarchicalCentroidCluster<T> a, HierarchicalCentroidCluster<T> b, HierarchicalCentroidCluster<T> composite, Symmetric2dBiMap<HierarchicalCentroidCluster<T>, Float> theActiveNodeDistanceMatrix) {
        HashSet<HierarchicalCentroidCluster<T>> activeKeys = new HashSet<HierarchicalCentroidCluster<T>>(theActiveNodeDistanceMatrix.getKeys());
        theActiveNodeDistanceMatrix.addKey(composite);
        for (HierarchicalCentroidCluster<T> node : activeKeys) {
            this.addCompositeVsNodeToDistanceMatrix(a, b, composite, node, theActiveNodeDistanceMatrix);
        }
    }

    public HierarchicalCentroidCluster<T> joinNodes(int id, HierarchicalCentroidCluster<T> a, HierarchicalCentroidCluster<T> b, Symmetric2dBiMap<HierarchicalCentroidCluster<T>, Float> theActiveNodeDistanceMatrix) {
        Float dist = theActiveNodeDistanceMatrix.get(a, b);
        Float distance = Float.valueOf(dist.floatValue() / 2.0f);
        a.setLength(distance.doubleValue());
        b.setLength(distance.doubleValue());
        HierarchicalCentroidCluster<Object> composite = new HierarchicalCentroidCluster<Object>(id, null);
        a.setParent((PhylogenyNode<Object>)composite);
        b.setParent((PhylogenyNode<Object>)composite);
        composite.addAll(a);
        composite.addAll(b);
        composite.setWeight(a.getWeight() + b.getWeight());
        assert (composite.getWeight() != null);
        composite.doneLabelling();
        assert (composite.getWeight() != null);
        int numActive = theActiveNodeDistanceMatrix.numKeys();
        assert (composite.getWeight() != null);
        this.addCompositeToDistanceMatrix(a, b, composite, theActiveNodeDistanceMatrix);
        assert (composite.getWeight() != null);
        if (numActive > 2) assert (theActiveNodeDistanceMatrix.numKeys() == numActive + 1);
        assert (composite.getChildren().size() > 0);
        return composite;
    }
}

