/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.bayesian;

import com.davidsoergel.dsutils.collections.WeightedSet;
import com.davidsoergel.stats.DissimilarityMeasure;
import com.davidsoergel.stats.DistributionException;
import com.davidsoergel.stats.Multinomial;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.TreeMultimap;
import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.CentroidCluster;
import edu.berkeley.compbio.ml.cluster.ClusterMove;
import edu.berkeley.compbio.ml.cluster.ClusterRuntimeException;
import edu.berkeley.compbio.ml.cluster.ClusteringTestResults;
import edu.berkeley.compbio.ml.cluster.NoGoodClusterException;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.bayesian.MultiNeighborClustering;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TacoaClustering<T extends AdditiveClusterable<T>>
extends MultiNeighborClustering<T> {
    private static final Logger logger = Logger.getLogger(TacoaClustering.class);
    private final double bestScoreRatioThreshold;

    public TacoaClustering(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels, int maxNeighbors, double bestScoreRatioThreshold) {
        super(dm, Double.POSITIVE_INFINITY, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels, maxNeighbors);
        this.bestScoreRatioThreshold = bestScoreRatioThreshold;
    }

    @Override
    protected synchronized void preparePriors() {
        try {
            HashMultiset<String> populatedTrainingLabels = HashMultiset.create();
            List immutableClusters = this.getClusters();
            for (CentroidCluster theCluster : immutableClusters) {
                try {
                    String label = theCluster.getImmutableWeightedLabels().getDominantKeyInSet(this.potentialTrainingBins);
                    populatedTrainingLabels.add(label);
                }
                catch (NoSuchElementException e) {
                    logger.warn("Cluster has no training label: " + theCluster);
                }
            }
            logger.info(String.valueOf(populatedTrainingLabels.size()) + " of " + this.getNumClusters() + " clusters have a training label; " + populatedTrainingLabels.entrySet().size() + " labels were trained");
            ImmutableMap.Builder<CentroidCluster, Double> builder = ImmutableMap.builder();
            Multinomial labelPriors = new Multinomial(populatedTrainingLabels);
            for (CentroidCluster theCluster : immutableClusters) {
                String label = theCluster.getImmutableWeightedLabels().getDominantKeyInSet(this.potentialTrainingBins);
                builder.put(theCluster, labelPriors.get(label));
            }
            this.clusterPriors = builder.build();
        }
        catch (DistributionException e) {
            logger.error("Error", e);
            throw new ClusterRuntimeException(e);
        }
    }

    @Override
    protected ClusterMove<T, CentroidCluster<T>> makeClusterMove(CentroidCluster<T> cluster, double distance) {
        ClusterMove cm = new ClusterMove();
        cm.bestCluster = cluster;
        cm.voteWeight = distance;
        cm.bestDistance = 1.0 / distance;
        return cm;
    }

    @Override
    protected WeightedSet<String> predictLabelWeights(ClusteringTestResults tr, T frag) {
        double secondToBestVoteRatio = 0.0;
        double voteProportion = 0.0;
        double bestVotes = 0.0;
        WeightedSet<String> labelWeights = null;
        try {
            TreeMultimap<Double, ClusterMove<T, CentroidCluster<T>>> moves = this.scoredClusterMoves(frag);
            MultiNeighborClustering.VotingResults votingResults = this.addUpNeighborVotes(moves);
            labelWeights = votingResults.getLabelVotes();
            MultiNeighborClustering.BestLabelPair votingWinners = votingResults.getSubResults(this.potentialTrainingBins);
            String predictedLabel = votingWinners.getBestLabel();
            bestVotes = labelWeights.get(predictedLabel);
            voteProportion = labelWeights.getNormalized(predictedLabel);
            if (votingWinners.hasSecondBestLabel()) {
                String secondBestLabel = votingWinners.getSecondBestLabel();
                double secondBestVotes = labelWeights.get(secondBestLabel);
                assert (secondBestVotes <= bestVotes);
                secondToBestVoteRatio = secondBestVotes / bestVotes;
                if (secondToBestVoteRatio > this.bestScoreRatioThreshold) {
                    throw new NoGoodClusterException();
                }
            } else {
                secondToBestVoteRatio = 1.0E308;
            }
        }
        catch (NoGoodClusterException e) {
            bestVotes = 1.0E-9;
            voteProportion = 0.0;
            secondToBestVoteRatio = 1.0;
            tr.incrementUnknown();
        }
        double bestDistance = 1.0 / bestVotes;
        double secondToBestDistanceRatio = 1.0 / secondToBestVoteRatio;
        tr.addClusterResult(bestDistance, secondToBestDistanceRatio, voteProportion, secondToBestVoteRatio);
        return labelWeights;
    }
}

