/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.bayesian;

import com.davidsoergel.dsutils.GenericFactory;
import com.davidsoergel.dsutils.GenericFactoryException;
import com.davidsoergel.stats.DissimilarityMeasure;
import com.davidsoergel.stats.DistributionException;
import com.davidsoergel.stats.Multinomial;
import com.google.common.collect.ImmutableMap;
import edu.berkeley.compbio.ml.cluster.AdditiveCentroidCluster;
import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.CentroidCluster;
import edu.berkeley.compbio.ml.cluster.ClusterMove;
import edu.berkeley.compbio.ml.cluster.ClusterRuntimeException;
import edu.berkeley.compbio.ml.cluster.ClusterableIterator;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.bayesian.NearestNeighborClustering;
import edu.berkeley.compbio.ml.cluster.kmeans.GrowableKmeansClustering;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelDecomposingBayesianClustering<T extends AdditiveClusterable<T>>
extends NearestNeighborClustering<T> {
    private static final Logger logger = Logger.getLogger(LabelDecomposingBayesianClustering.class);
    GenericFactory<T> prototypeFactory;

    public LabelDecomposingBayesianClustering(DissimilarityMeasure<T> dm, double unknownDistanceThreshold, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels) {
        super(dm, unknownDistanceThreshold, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels);
    }

    @Override
    public void setPrototypeFactory(GenericFactory<T> prototypeFactory) throws GenericFactoryException {
        this.prototypeFactory = prototypeFactory;
    }

    @Override
    protected void trainWithKnownTrainingLabels(ClusterableIterator<T> trainingIterator) {
        throw new NotImplementedException();
    }

    public void initializeWithSamples(ClusterableIterator<T> trainingIterator, int initSamples) {
        HashMap<String, GrowableKmeansClustering<AdditiveClusterable>> theSubclusteringMap = new HashMap<String, GrowableKmeansClustering<AdditiveClusterable>>();
        if (this.predictLabelSets.size() > 1) {
            throw new ClusterRuntimeException("LabelDecomposingBayesianClustering can't yet handle more than one exclusive label set at a time: " + this.predictLabelSets.keySet());
        }
        Set predictLabels = (Set)this.predictLabelSets.values().iterator().next();
        try {
            Multinomial<AdditiveCentroidCluster<AdditiveClusterable>> priorsMult = new Multinomial<AdditiveCentroidCluster<AdditiveClusterable>>();
            try {
                int i = 0;
                while (true) {
                    AdditiveClusterable point2;
                    String bestLabel;
                    GrowableKmeansClustering<AdditiveClusterable> theIntraLabelClustering;
                    if ((theIntraLabelClustering = (GrowableKmeansClustering<AdditiveClusterable>)theSubclusteringMap.get(bestLabel = (String)(point2 = (AdditiveClusterable)trainingIterator.nextFullyLabelled()).getImmutableWeightedLabels().getDominantKeyInSet(predictLabels))) == null) {
                        theIntraLabelClustering = new GrowableKmeansClustering<AdditiveClusterable>(this.measure, this.potentialTrainingBins, this.predictLabelSets, this.prohibitionModel, this.testLabels);
                        theSubclusteringMap.put(bestLabel, theIntraLabelClustering);
                    }
                    ClusterMove<AdditiveClusterable, CentroidCluster<AdditiveClusterable>> cm = theIntraLabelClustering.bestClusterMove(point2);
                    AdditiveCentroidCluster<AdditiveClusterable> cluster = (AdditiveCentroidCluster<AdditiveClusterable>)cm.bestCluster;
                    if (cm.bestDistance > this.unknownDistanceThreshold) {
                        logger.debug("Creating new subcluster (" + cm.bestDistance + " > " + this.unknownDistanceThreshold + ") for " + bestLabel);
                        cluster = new AdditiveCentroidCluster<AdditiveClusterable>(i++, (AdditiveClusterable)this.prototypeFactory.create(new Object[0]));
                        theIntraLabelClustering.addCluster(cluster);
                        this.addCluster(cluster);
                        priorsMult.put(cluster, 1.0);
                    }
                    cluster.add(point2);
                }
            }
            catch (NoSuchElementException e) {
                priorsMult.normalize();
                ImmutableMap.Builder builder = ImmutableMap.builder();
                this.clusterPriors = builder.putAll(priorsMult.getValueMap()).build();
                for (Map.Entry entry : theSubclusteringMap.entrySet()) {
                    String label = (String)entry.getKey();
                    GrowableKmeansClustering theIntraLabelClustering = (GrowableKmeansClustering)entry.getValue();
                    if (!logger.isInfoEnabled()) continue;
                    logger.info("Created " + theIntraLabelClustering.getClusters().size() + " clusters from " + theIntraLabelClustering.getN() + " points for " + label);
                }
            }
        }
        catch (DistributionException e) {
            throw new ClusterRuntimeException(e);
        }
        catch (GenericFactoryException e) {
            throw new ClusterRuntimeException(e);
        }
    }
}

