/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.bayesian;

import com.davidsoergel.dsutils.collections.WeightedSet;
import com.davidsoergel.stats.DissimilarityMeasure;
import com.davidsoergel.stats.SimpleFunction;
import com.google.common.collect.TreeMultimap;
import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.CentroidCluster;
import edu.berkeley.compbio.ml.cluster.ClusterMove;
import edu.berkeley.compbio.ml.cluster.ClusteringTestResults;
import edu.berkeley.compbio.ml.cluster.NoGoodClusterException;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.bayesian.MultiNeighborClustering;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KNNClustering<T extends AdditiveClusterable<T>>
extends MultiNeighborClustering<T> {
    private static final Logger logger = Logger.getLogger(KNNClustering.class);
    private final double voteProportionThreshold;
    private final double distanceTieThresholdRatio;
    private final double voteTieThresholdRatio;
    private SimpleFunction function = null;

    public KNNClustering(DissimilarityMeasure<T> dm, double unknownDistanceThreshold, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels, int maxNeighbors, double voteProportionThreshold, double voteTieThresholdRatio, double distanceTieThresholdRatio, SimpleFunction function) {
        super(dm, unknownDistanceThreshold, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels, maxNeighbors);
        this.voteProportionThreshold = voteProportionThreshold;
        this.voteTieThresholdRatio = voteTieThresholdRatio;
        this.distanceTieThresholdRatio = distanceTieThresholdRatio;
        this.function = function;
    }

    @Override
    protected ClusterMove<T, CentroidCluster<T>> makeClusterMove(CentroidCluster<T> cluster, double distance) {
        ClusterMove cm = new ClusterMove();
        cm.bestCluster = cluster;
        cm.bestDistance = distance;
        if (this.function != null) {
            cm.voteWeight = this.function.f(distance);
        }
        return cm;
    }

    @Override
    protected WeightedSet<String> predictLabelWeights(ClusteringTestResults tr, T frag) {
        double secondToBestDistanceRatio;
        double bestWeightedDistance;
        double secondToBestVoteRatio = 0.0;
        double voteProportion = 0.0;
        WeightedSet<String> labelWeights = null;
        try {
            TreeMultimap<Double, ClusterMove<T, CentroidCluster<T>>> moves = this.scoredClusterMoves(frag);
            MultiNeighborClustering.VotingResults votingResults = this.addUpNeighborVotes(moves);
            labelWeights = votingResults.getLabelVotes();
            if (labelWeights.getItemCount() == 0) {
                throw new NoGoodClusterException();
            }
            MultiNeighborClustering.BestLabelPair votingWinners = votingResults.getSubResults(this.potentialTrainingBins);
            String predictedLabel = votingWinners.getBestLabel();
            bestWeightedDistance = votingResults.computeWeightedDistance(predictedLabel);
            if (votingWinners.hasSecondBestLabel()) {
                String secondBestLabel = votingWinners.getSecondBestLabel();
                double bestVotes = labelWeights.get(predictedLabel);
                double secondBestVotes = labelWeights.get(secondBestLabel);
                assert (secondBestVotes <= bestVotes);
                double secondBestWeightedDistance = votingResults.computeWeightedDistance(secondBestLabel);
                secondToBestVoteRatio = secondBestVotes / bestVotes;
                secondToBestDistanceRatio = secondBestWeightedDistance / bestWeightedDistance;
                if (secondToBestVoteRatio >= this.voteTieThresholdRatio) {
                    double minRatio = this.distanceTieThresholdRatio;
                    double maxRatio = 1.0 / this.distanceTieThresholdRatio;
                    if (!(secondToBestDistanceRatio < minRatio) && !(secondToBestDistanceRatio > maxRatio)) {
                        throw new NoGoodClusterException();
                    }
                    if (!(bestWeightedDistance < secondBestWeightedDistance)) {
                        predictedLabel = secondBestLabel;
                        bestWeightedDistance = secondBestWeightedDistance;
                    }
                }
            } else {
                secondToBestVoteRatio = 0.0;
                secondToBestDistanceRatio = 1.0E308;
            }
            voteProportion = labelWeights.getNormalized(predictedLabel);
            if (voteProportion < this.voteProportionThreshold) {
                throw new NoGoodClusterException();
            }
        }
        catch (NoGoodClusterException e) {
            bestWeightedDistance = Double.NaN;
            secondToBestDistanceRatio = 1.0;
            voteProportion = 0.0;
            secondToBestVoteRatio = 1.0;
            tr.incrementUnknown();
        }
        tr.addClusterResult(bestWeightedDistance, secondToBestDistanceRatio, voteProportion, secondToBestVoteRatio);
        return labelWeights;
    }
}

