/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.bayesian;

import com.davidsoergel.conja.Function;
import com.davidsoergel.conja.Parallel;
import com.davidsoergel.dsutils.GenericFactory;
import com.davidsoergel.dsutils.GenericFactoryException;
import com.davidsoergel.stats.DissimilarityMeasure;
import edu.berkeley.compbio.ml.cluster.AdditiveCentroidCluster;
import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.ClusterRuntimeException;
import edu.berkeley.compbio.ml.cluster.ClusterableIterator;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.bayesian.NearestNeighborClustering;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BayesianClustering<T extends AdditiveClusterable<T>>
extends NearestNeighborClustering<T> {
    private static final Logger logger = Logger.getLogger(BayesianClustering.class);
    private GenericFactory<T> prototypeFactory;

    public BayesianClustering(DissimilarityMeasure<T> dm, double unknownDistanceThreshold, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels) {
        super(dm, unknownDistanceThreshold, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels);
    }

    @Override
    public void setPrototypeFactory(GenericFactory<T> prototypeFactory) {
        assert (this.getNumClusters() == 0);
        this.prototypeFactory = prototypeFactory;
    }

    @Override
    protected synchronized void trainWithKnownTrainingLabels(ClusterableIterator<T> trainingIterator) {
        final ConcurrentHashMap theClusterMap = new ConcurrentHashMap();
        final AtomicInteger i = new AtomicInteger(0);
        Parallel.forEach(trainingIterator, new Function<T, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void apply(@Nullable T point2) {
                String clusterBinId = (String)point2.getImmutableWeightedLabels().getDominantKeyInSet(BayesianClustering.this.potentialTrainingBins);
                Map map = theClusterMap;
                synchronized (map) {
                    AdditiveCentroidCluster<AdditiveClusterable> cluster = (AdditiveCentroidCluster<AdditiveClusterable>)theClusterMap.get(clusterBinId);
                    if (cluster == null) {
                        try {
                            AdditiveClusterable centroid = (AdditiveClusterable)BayesianClustering.this.prototypeFactory.create(clusterBinId);
                            int clusterId = i.incrementAndGet();
                            cluster = new AdditiveCentroidCluster<AdditiveClusterable>(clusterId, centroid);
                            BayesianClustering.this.addCluster(cluster);
                            theClusterMap.put(clusterBinId, cluster);
                        }
                        catch (GenericFactoryException e) {
                            logger.error("Error", e);
                            throw new ClusterRuntimeException(e);
                        }
                    }
                    cluster.add((AdditiveClusterable)point2);
                }
                return null;
            }
        });
    }
}

